/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Collections;
import java.util.Set;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.Node;
import org.spockframework.runtime.ErrorInfoCollector;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.SpockNode;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import spock.config.RunnerConfiguration;

public class IterationNode
extends SpockNode<FeatureInfo> {
    private final IterationInfo iterationInfo;

    protected IterationNode(UniqueId uniqueId, RunnerConfiguration configuration, IterationInfo iterationInfo) {
        super(uniqueId, iterationInfo.getDisplayName(), (TestSource)IterationNode.featureToMethodSource(iterationInfo.getFeature()), configuration, iterationInfo.getFeature());
        this.iterationInfo = iterationInfo;
    }

    public SpockExecutionContext prepare(SpockExecutionContext context) throws Exception {
        if (this.iterationInfo.getFeature().isSkipped()) {
            return context;
        }
        context.getErrorInfoCollector().assertEmpty();
        context = context.withCurrentIteration(this.iterationInfo);
        context = context.getRunner().createSpecInstance(context, false);
        context.getRunner().runInitializer(context);
        context.getErrorInfoCollector().assertEmpty();
        return context;
    }

    public SpockExecutionContext before(SpockExecutionContext context) throws Exception {
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        context.getRunner().runSetup(context);
        errorInfoCollector.assertEmpty();
        return context;
    }

    public SpockExecutionContext execute(SpockExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        this.verifyNotSkipped(this.iterationInfo.getFeature());
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        context.getRunner().runFeatureMethod(context);
        errorInfoCollector.assertEmpty();
        return context;
    }

    public void after(SpockExecutionContext context) throws Exception {
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        context.getRunner().runCleanup(context);
        errorInfoCollector.assertEmpty();
    }

    public void around(SpockExecutionContext context, Node.Invocation<SpockExecutionContext> invocation) {
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        SpockExecutionContext innerContext = context.withErrorInfoCollector(errorInfoCollector);
        innerContext.getRunner().runIteration(innerContext, this.iterationInfo, () -> this.sneakyInvoke(invocation, innerContext));
        errorInfoCollector.assertEmpty();
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Node.SkipResult shouldBeSkipped(SpockExecutionContext context) {
        return this.shouldBeSkipped(this.iterationInfo.getFeature());
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        return Collections.emptySet();
    }
}

