/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import java.util.Collections;
import java.util.List;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.ConditionalExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.IgnoreIf;

public class IgnoreIfExtension
extends ConditionalExtension<IgnoreIf> {
    private static final String DEFAULT_MESSAGE = "Ignored via @" + IgnoreIf.class.getSimpleName();

    @Override
    protected Class<? extends Closure> getConditionClass(IgnoreIf annotation) {
        return annotation.value();
    }

    @Override
    protected void specConditionResult(boolean result, IgnoreIf annotation, SpecInfo spec) {
        if (!result) {
            return;
        }
        List<SpecInfo> specsToSkip = annotation.inherited() ? spec.getSpecsCurrentToBottom() : Collections.singletonList(spec);
        specsToSkip.forEach(toSkip -> toSkip.skip(IgnoreIfExtension.ignoredMessage(annotation)));
    }

    @Override
    protected void featureConditionResult(boolean result, IgnoreIf annotation, FeatureInfo feature) {
        if (result) {
            feature.skip(IgnoreIfExtension.ignoredMessage(annotation));
        }
    }

    @Override
    protected void iterationConditionResult(boolean result, IgnoreIf annotation, IMethodInvocation invocation) {
        if (result) {
            throw new TestAbortedException(IgnoreIfExtension.ignoredMessage(annotation));
        }
    }

    private static String ignoredMessage(IgnoreIf annotation) {
        String reason = annotation.reason();
        if (reason.isEmpty()) {
            return DEFAULT_MESSAGE;
        }
        return DEFAULT_MESSAGE + ": " + reason;
    }
}

