/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.util.ReflectionUtils;

class ExecutorMethodInterceptor<T extends Executor>
implements MethodInterceptor {
    private final T delegate;
    private final BeanFactory beanFactory;
    private final String beanName;
    private static final Map<Executor, Executor> CACHE = new ConcurrentHashMap<Executor, Executor>();

    ExecutorMethodInterceptor(T delegate, BeanFactory beanFactory, String beanName) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
        this.beanName = beanName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        T executor = this.executor(this.beanFactory, this.delegate, this.beanName);
        Method methodOnTracedBean = this.getMethod(invocation, executor);
        if (methodOnTracedBean != null) {
            try {
                return methodOnTracedBean.invoke(executor, invocation.getArguments());
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                throw cause != null ? cause : ex;
            }
        }
        return invocation.proceed();
    }

    private Method getMethod(MethodInvocation invocation, Object object) {
        Method method = invocation.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }

    T executor(BeanFactory beanFactory, T executor, String beanName) {
        return this.executorFromCache(beanFactory, executor, beanName, e -> LazyTraceExecutor.wrap(beanFactory, e, beanName));
    }

    T executorFromCache(BeanFactory beanFactory, T executor, String beanName, Function<Executor, Executor> function) {
        return (T)CACHE.computeIfAbsent((Executor)executor, function);
    }
}

