/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.core.credentials;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public class CredentialsProviderFactoryBean
extends AbstractFactoryBean<AWSCredentialsProvider> {
    public static final String CREDENTIALS_PROVIDER_BEAN_NAME = "credentialsProvider";
    private final List<AWSCredentialsProvider> delegates;

    public CredentialsProviderFactoryBean() {
        this(Collections.emptyList());
    }

    public CredentialsProviderFactoryBean(List<AWSCredentialsProvider> delegates) {
        Assert.notNull(delegates, (String)"Delegates must not be null");
        this.delegates = delegates;
    }

    public Class<?> getObjectType() {
        return AWSCredentialsProvider.class;
    }

    protected AWSCredentialsProvider createInstance() throws Exception {
        Object awsCredentialsProviderChain = this.delegates.isEmpty() ? new DefaultAWSCredentialsProviderChain() : new AWSCredentialsProviderChain(this.delegates.toArray(new AWSCredentialsProvider[this.delegates.size()]));
        awsCredentialsProviderChain.setReuseLastProvider(false);
        return awsCredentialsProviderChain;
    }
}

