/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import io.higson.runtime.core.HigsonEngine;
import io.higson.runtime.core.HigsonEngineFactory;
import io.higson.runtime.core.domain.DomainCache;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import pl.decerto.hyperon.common.external.CoreExternalDataSourceProvider;
import pl.decerto.hyperon.rest.configuration.HyperonEngineProperties;

@Configuration
public class HyperonEngineConfiguration {
    private final CoreExternalDataSourceProvider externalDataSourceProvider;

    @Bean(destroyMethod="destroy")
    public HigsonEngineFactory higsonEngineFactory(DataSource dataSource, HyperonEngineProperties engineProperties) {
        this.externalDataSourceProvider.configure(dataSource);
        HigsonEngineFactory higsonEngineFactory = new HigsonEngineFactory();
        higsonEngineFactory.setDataSource(dataSource);
        higsonEngineFactory.setDeveloperMode(engineProperties.isDevMode());
        if (engineProperties.isDevMode()) {
            higsonEngineFactory.setUsername(engineProperties.getDevUserName());
        }
        higsonEngineFactory.addExternalDataSources(this.externalDataSourceProvider.getDataSourceMap());
        higsonEngineFactory.setValidateFunctionArgumentsDataTypes(engineProperties.isValidateFunctionArgumentsDataTypes());
        higsonEngineFactory.setThrowOnNormalizeInputValueException(engineProperties.isThrowOnNormalizeInputValueException());
        higsonEngineFactory.setGroovySecured(engineProperties.isGroovySecured());
        return higsonEngineFactory;
    }

    @Bean
    public HigsonEngine higsonEngine(HigsonEngineFactory engineFactory) {
        return engineFactory.create();
    }

    @Bean
    @DependsOn(value={"higsonEngine"})
    public DomainCache domainCache(HigsonEngineFactory engineFactory) {
        return engineFactory.getDomainCache();
    }

    public HyperonEngineConfiguration(CoreExternalDataSourceProvider externalDataSourceProvider) {
        this.externalDataSourceProvider = externalDataSourceProvider;
    }
}

