/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.jwt.JwtSecretKeyNotSpecifiedException;
import pl.decerto.hyperon.common.utils.Messages;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtTokenNotValidException;

@Component
@ConditionalOnProperty(name={"higson.runtime-rest.security.type"}, havingValue="jwt")
class JwtTokenParser {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenParser.class);
    private final String secretKey;

    JwtTokenParser(@Value(value="${higson.security.jwt.secret-key:#{null}}") String secretKey) {
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            throw new JwtSecretKeyNotSpecifiedException(Messages.message((String)"jwt.secret.notSpecified"));
        }
        this.secretKey = secretKey;
    }

    Jws<Claims> parse(String token) {
        try {
            String encodedSecretKey = Base64.getEncoder().encodeToString(this.secretKey.getBytes());
            return Jwts.parserBuilder().setSigningKey(encodedSecretKey).build().parseClaimsJws(token);
        }
        catch (JwtException | IllegalArgumentException ex) {
            log.error("", ex);
            throw new JwtTokenNotValidException("Expired or invalid JWT token");
        }
    }
}

