/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtTokenNotValidException;
import pl.decerto.hyperon.rest.configuration.security.jwt.JwtTokenUtils;

@Service
@ConditionalOnProperty(name={"higson.runtime-rest.security.type"}, havingValue="jwt")
class JwtUserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(JwtUserDetailsService.class);
    private final UserManagementDao userManagementDao;

    UserDetails loadUser(Jws<Claims> claims) {
        String userLogin = JwtTokenUtils.getClaimOrThrow("userLogin", claims);
        String userFirstName = JwtTokenUtils.getClaimOrThrow("firstName", claims);
        String userLastName = JwtTokenUtils.getClaimOrThrow("lastName", claims);
        String userEmail = JwtTokenUtils.getClaimOrThrow("email", claims);
        SystemUserJPA systemUserJPA = this.userManagementDao.findByLogin(userLogin);
        if (systemUserJPA == null) {
            throw new JwtTokenNotValidException(String.format("Cannot find user with login: '%s' from token", userLogin));
        }
        if (this.isClaimsObjectNotValid(systemUserJPA, userFirstName, userLastName, userEmail)) {
            throw new JwtTokenNotValidException("Payload values from JWT token are not equal with loaded user");
        }
        return User.withUsername((String)userLogin).authorities(new String[]{userFirstName, userLastName, userEmail}).password("").accountExpired(false).accountLocked(false).credentialsExpired(false).disabled(false).build();
    }

    private boolean isClaimsObjectNotValid(SystemUserJPA systemUserJPA, String userFirstName, String userLastName, String userEmail) {
        if (!userFirstName.equals(systemUserJPA.getFirstName())) {
            return true;
        }
        if (!userLastName.equals(systemUserJPA.getLastName())) {
            return true;
        }
        return !userEmail.equals(systemUserJPA.getEmail());
    }

    public JwtUserDetailsService(UserManagementDao userManagementDao) {
        this.userManagementDao = userManagementDao;
    }
}

