/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.execution.api.dto;

import io.higson.runtime.engine.core.UnknownParameterException;
import io.higson.runtime.engine.core.function.UnknownFunctionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import pl.decerto.hyperon.rest.execution.MissingAttributeException;
import pl.decerto.hyperon.rest.execution.api.validator.BadRequestExecption;

@ControllerAdvice
public class ErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ErrorControllerAdvice.class);

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorResponse handleBadRequestExceptions(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorResponse handleOtherExceptions(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorResponse handleOtherExceptions(BadRequestExecption e) {
        log.error("Failed to invoke API request", (Throwable)e);
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={UnknownParameterException.class, UnknownFunctionException.class, MissingAttributeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ErrorResponse unknownElementExceptionHandler(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return new ErrorResponse(e.getMessage());
    }

    static final class ErrorResponse {
        private final String message;

        public ErrorResponse(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorResponse)) {
                return false;
            }
            ErrorResponse other = (ErrorResponse)o;
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "ErrorControllerAdvice.ErrorResponse(message=" + this.getMessage() + ")";
        }
    }
}

