/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.cache.UserCacheEntry;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.rest.security.SystemUserCacheAwareProvider;

public class CachingHyperonUserDetailsService
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(CachingHyperonUserDetailsService.class);
    private final UsersCacheManager userCache;
    private final SystemUserCacheAwareProvider systemUserCacheAwareProvider;

    @Transactional
    public UserDetails loadUserByUsername(String login) throws UsernameNotFoundException {
        log.trace("enter loadUserByUsername(login={})", (Object)login);
        SystemUser user = this.systemUserCacheAwareProvider.getSystemUser(login);
        return MppUserDetails.createMppUserDetails((SystemUser)user, (UserCacheEntry)this.userCache.getUserCacheEntry(login));
    }

    public CachingHyperonUserDetailsService(UsersCacheManager userCache, SystemUserCacheAwareProvider systemUserCacheAwareProvider) {
        this.userCache = userCache;
        this.systemUserCacheAwareProvider = systemUserCacheAwareProvider;
    }
}

