/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.observation;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;

class ObservationHandlerGrouping {
    private final List<Class<? extends ObservationHandler>> categories;

    ObservationHandlerGrouping(Class<? extends ObservationHandler> category) {
        this(List.of(category));
    }

    ObservationHandlerGrouping(List<Class<? extends ObservationHandler>> categories) {
        this.categories = categories;
    }

    void apply(List<ObservationHandler<?>> handlers, ObservationRegistry.ObservationConfig config) {
        LinkedMultiValueMap groupings = new LinkedMultiValueMap();
        ArrayList handlersWithoutCategory = new ArrayList();
        for (ObservationHandler<?> observationHandler : handlers) {
            Class<? extends ObservationHandler> category = this.findCategory(observationHandler);
            if (category != null) {
                groupings.add(category, observationHandler);
                continue;
            }
            handlersWithoutCategory.add(observationHandler);
        }
        for (Class clazz : this.categories) {
            List handlerGroup = (List)groupings.get((Object)clazz);
            if (CollectionUtils.isEmpty((Collection)handlerGroup)) continue;
            config.observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(handlerGroup));
        }
        for (ObservationHandler observationHandler : handlersWithoutCategory) {
            config.observationHandler(observationHandler);
        }
    }

    private Class<? extends ObservationHandler> findCategory(ObservationHandler<?> handler) {
        for (Class<? extends ObservationHandler> category : this.categories) {
            if (!category.isInstance(handler)) continue;
            return category;
        }
        return null;
    }
}

