/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.builtin.utils.IdentifyValueUtil;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.bool.BooleanHolder;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.string.StringHolder;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.rhino.value.RhinoParamValue;
import java.util.Collection;

public class SizeUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    public static final String CODE = "size";
    public static final UtilFunction INSTANCE = new SizeUtilFunction();

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        Object obj = ctx.get(path);
        if (obj == null) {
            return null;
        }
        return this.size(obj, path);
    }

    private Object size(Object obj, String path) {
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return collection.size();
        }
        return IdentifyValueUtil.identify(obj).map(this::getSupportedType).map(targetObjectHolder -> this.getSize(obj, (ValueHolder)targetObjectHolder, path)).orElse(null);
    }

    private ValueHolder getSupportedType(ValueHolder targetObjectHolder) {
        if (targetObjectHolder instanceof NumberHolder || targetObjectHolder instanceof IntegerHolder || targetObjectHolder instanceof BooleanHolder || targetObjectHolder instanceof LocalDateHolder || targetObjectHolder instanceof LocalDateTimeHolder) {
            throw this.createHigsonRuntimeException(CODE, "Unsupported element type for formatting: " + targetObjectHolder.getValue().getClass().getSimpleName());
        }
        return targetObjectHolder;
    }

    private Object getSize(Object obj, ValueHolder targetObjectHolder, String path) {
        if (obj instanceof ParamValue) {
            ParamValue paramValue = (ParamValue)obj;
            return paramValue.size();
        }
        if (obj instanceof RhinoParamValue) {
            RhinoParamValue paramValue = (RhinoParamValue)obj;
            return paramValue.size();
        }
        if (obj instanceof MultiValue) {
            MultiValue multiValue = (MultiValue)obj;
            return multiValue.size();
        }
        if (obj instanceof ValueHolder) {
            ValueHolder valueHolder = (ValueHolder)obj;
            return valueHolder.intValue();
        }
        if (targetObjectHolder instanceof StringHolder) {
            StringHolder targetHolder = (StringHolder)targetObjectHolder;
            return targetHolder.getValue().length();
        }
        throw this.createSizeNotSupportedException(path);
    }

    private HigsonRuntimeException createSizeNotSupportedException(String path) {
        return this.createHigsonRuntimeException(CODE, " Size of " + path + " is not supported");
    }

    private SizeUtilFunction() {
    }
}

