/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import io.higson.runtime.core.datasource.snapshot.SnapshotPath;
import io.higson.runtime.core.datasource.snapshot.domain.DomainSupportedFiles;
import io.higson.runtime.core.datasource.snapshot.domain.ElementWithRegionVersion;
import io.higson.runtime.core.datasource.snapshot.domain.PathUtils;
import io.higson.runtime.helper.snapshot.SnapshotFileHelper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainDirectoryAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(DomainDirectoryAnalyzer.class);
    private final SnapshotFileHelper fileHelper;

    public DomainDirectoryAnalyzer(SnapshotFileHelper fileHelper) {
        this.fileHelper = fileHelper;
    }

    public List<ElementWithRegionVersion> getNamesFromRegionVersionDirectory(Path dir) throws IOException {
        Optional<Path> regionDir = this.getRegionDir(dir);
        if (!regionDir.isPresent()) {
            return Collections.emptyList();
        }
        List<Path> walk = this.getChildrenUpToThirdLevel(regionDir.get());
        return walk.stream().filter(this::isNotRegionDir).filter(path -> this.isNotRegionDir(this.getVersion((Path)path))).filter(path -> this.isNotRegionDir(this.getRegionCodeDir((Path)path))).filter(this.fileHelper::isDirectory).map(path -> {
            String regionCode = this.fileHelper.getDirectoryName(this.getRegionCodeDir((Path)path));
            String version = this.fileHelper.getDirectoryName(this.getVersion((Path)path));
            String elementName = this.fileHelper.getDirectoryName((Path)path);
            return new ElementWithRegionVersion(elementName, regionCode, version);
        }).collect(Collectors.toList());
    }

    private Path getVersion(Path path) {
        return path.getParent();
    }

    private Path getRegionCodeDir(Path path) {
        return path.getParent().getParent();
    }

    public List<String> getSubDirNames(Path dir) throws IOException {
        List<String> result;
        try (Stream<Path> stream = Files.list(dir);){
            result = stream.filter(this.fileHelper::isDirectory).filter(subDir -> !subDir.endsWith(SnapshotPath.REGIONS_WITH_SEPARATOR.getPath())).filter(subDir -> !PathUtils.hasFile(subDir, DomainSupportedFiles.REFERENCE.getFileName())).map(this.fileHelper::getDirectoryName).collect(Collectors.toList());
        }
        return result;
    }

    private boolean isNotRegionDir(Path pathToCheck) {
        return !this.fileHelper.getDirectoryName(pathToCheck).equals(SnapshotPath.REGIONS.getPath());
    }

    private Optional<Path> getRegionDir(Path dir) throws IOException {
        Optional<Path> result;
        try (Stream<Path> stream = Files.list(dir);){
            result = stream.filter(this.fileHelper::isDirectory).filter(subDir -> subDir.endsWith(SnapshotPath.REGIONS_WITH_SEPARATOR.getPath())).findFirst();
        }
        return result;
    }

    private List<Path> getChildrenUpToThirdLevel(Path dir) throws IOException {
        try (Stream<Path> walk = Files.walk(dir, 3, new FileVisitOption[0]);){
            List<Path> list = walk.collect(Collectors.toList());
            return list;
        }
    }
}

