/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import io.higson.runtime.core.datasource.snapshot.domain.AttributeProcessor;
import io.higson.runtime.core.datasource.snapshot.domain.DomainSupportedFiles;
import io.higson.runtime.core.datasource.snapshot.domain.DomainWrapper;
import io.higson.runtime.core.datasource.snapshot.domain.ImportSnapshotException;
import io.higson.runtime.core.datasource.snapshot.domain.InfoProcessor;
import io.higson.runtime.core.datasource.snapshot.domain.ReferenceProcessor;
import java.io.IOException;
import java.nio.file.Path;

public class DomainImportFilesProcessor {
    private final AttributeProcessor attributeProcessor;
    private final ReferenceProcessor referenceProcessor;
    private final InfoProcessor infoProcessor;

    public DomainImportFilesProcessor(AttributeProcessor attributeProcessor, ReferenceProcessor referenceProcessor, InfoProcessor infoProcessor) {
        this.attributeProcessor = attributeProcessor;
        this.referenceProcessor = referenceProcessor;
        this.infoProcessor = infoProcessor;
    }

    public void process(DomainWrapper domainWrapper, Path file) {
        try {
            this.tryProcess(domainWrapper, file);
        }
        catch (IOException ex) {
            throw new ImportSnapshotException(ex.getMessage(), ex);
        }
    }

    private void tryProcess(DomainWrapper domainWrapper, Path file) throws IOException {
        if (this.isAttributeFile(file)) {
            this.attributeProcessor.process(domainWrapper, file);
        } else if (this.isReferenceFile(file)) {
            this.referenceProcessor.process(domainWrapper, file);
        } else if (this.isInfoFile(file)) {
            this.infoProcessor.process(domainWrapper, file);
        }
    }

    public boolean isFileAcceptable(Path file) {
        return this.isAttributeFile(file) || this.isInfoFile(file) || this.isReferenceFile(file);
    }

    private boolean isInfoFile(Path file) {
        return file.endsWith(DomainSupportedFiles.INFO.getFileName());
    }

    private boolean isAttributeFile(Path file) {
        return file.endsWith(DomainSupportedFiles.ATTRIBUTES.getFileName());
    }

    private boolean isReferenceFile(Path file) {
        return file.endsWith(DomainSupportedFiles.REFERENCE.getFileName());
    }
}

