/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import io.higson.runtime.core.datasource.snapshot.domain.DomainElementWrapper;
import io.higson.runtime.core.datasource.snapshot.domain.DomainWrapper;
import io.higson.runtime.core.datasource.snapshot.domain.SnapshotModelConverter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.mpp.imports.xml.domain.DomainElement;
import pl.decerto.mpp.imports.xml.domain.Tags;

public class InfoProcessor {
    private static final Logger log = LoggerFactory.getLogger(InfoProcessor.class);
    private SnapshotModelConverter<DomainElementWrapper> converter;

    public void process(DomainWrapper domainWrapper, Path file) throws IOException {
        DomainElementWrapper model;
        try {
            model = this.converter.createModel(file);
        }
        catch (IllegalStateException e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        DomainElement domainElement = domainWrapper.getDomainElement();
        this.setName(model, domainElement);
        this.setTags(model, domainElement);
        this.setDescription(model, domainElement);
    }

    private void setName(DomainElementWrapper model, DomainElement domainElement) {
        String nameFromFile = model.getName();
        if (StringUtils.isNotBlank((CharSequence)nameFromFile)) {
            domainElement.setName(nameFromFile);
        }
    }

    private void setDescription(DomainElementWrapper model, DomainElement domainElement) {
        String descriptionFromFile = model.getDescription();
        if (StringUtils.isNotBlank((CharSequence)descriptionFromFile)) {
            domainElement.setDescription(descriptionFromFile);
        }
    }

    private void setTags(DomainElementWrapper model, DomainElement domainElement) {
        List<Object> tagsNameFromFile;
        List<Object> list = tagsNameFromFile = model.getTags() == null ? Collections.emptyList() : model.getTags();
        if (domainElement.getTags() == null) {
            domainElement.setTags(new Tags());
        }
        domainElement.getTags().getTagName().addAll(tagsNameFromFile);
    }

    public InfoProcessor(SnapshotModelConverter<DomainElementWrapper> converter) {
        this.converter = converter;
    }
}

