/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.core.datasource.snapshot.domain;

import io.higson.runtime.core.datasource.DomainCacheDao;
import io.higson.runtime.core.datasource.VersionDao;
import io.higson.runtime.core.datasource.snapshot.domain.AttributeType;
import io.higson.runtime.core.datasource.snapshot.domain.CollectionElement;
import io.higson.runtime.core.datasource.snapshot.domain.Element;
import io.higson.runtime.core.datasource.snapshot.domain.ElementAttribute;
import io.higson.runtime.core.datasource.snapshot.domain.ElementAttributeExtra;
import io.higson.runtime.core.datasource.snapshot.domain.ReferenceElement;
import io.higson.runtime.core.datasource.snapshot.domain.SnapshotDomainDirReader;
import io.higson.runtime.core.datasource.snapshot.helper.SnapshotDataSourceConstants;
import io.higson.runtime.core.domain.AttributeValueProvider;
import io.higson.runtime.dao.util.LoadTime;
import io.higson.runtime.model.AttributeDefinitionImpl;
import io.higson.runtime.model.DomainAttributeDto;
import io.higson.runtime.model.DomainObjectImpl;
import io.higson.runtime.model.DomainObjectTypeImpl;
import io.higson.runtime.model.OpenSession;
import io.higson.runtime.model.ReferenceDto;
import io.higson.runtime.model.RegionCached;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.Type;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SnapshotDomainCacheDao
implements DomainCacheDao {
    private final SnapshotDomainDirReader dirReader;
    private final VersionDao versionDao;

    @Override
    public Date getDomainElementLastUpdate() {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public Date getRegionVersionLastUpdate() {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public Date getDomainDefinitionLastUpdate() {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public Map<String, DomainObjectTypeImpl> getTypesByCode(String profileCode) {
        return this.dirReader.getCollectionElements(profileCode).stream().map(SnapshotDomainCacheDao::buildType).collect(Collectors.toMap(collection -> Integer.toString(collection.getId()), Function.identity()));
    }

    @Override
    public Integer getCollectionId(int elementId) {
        return null;
    }

    @Override
    public Map<String, DomainObjectImpl> getObjectsById(String profileCode, int sessionId, Map<String, DomainObjectTypeImpl> types, Set<Integer> versions) {
        List<RegionVersion> allVersions = this.versionDao.getAllRegionVersionsList();
        return this.dirReader.getElements(profileCode).stream().map(object -> SnapshotDomainCacheDao.buildDomainObject(object, allVersions, types)).filter(object -> object.getRegion() == null || versions.contains(object.getRegion().getVersionId())).collect(Collectors.toMap(object -> Integer.toString(object.getId()), Function.identity()));
    }

    @Override
    public Map<String, Integer> getNewParents(String profileCode, Set<Integer> userRegionVersions) {
        return Collections.emptyMap();
    }

    @Override
    public DomainObjectImpl getObjectById(int elementId, String path, DomainObjectTypeImpl type, AttributeValueProvider valueProvider, Set<Integer> regionIds) {
        return null;
    }

    @Override
    public Map<String, List<ReferenceDto>> getReferences(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        return this.dirReader.getDomain(profileCode).referenceElements().stream().collect(Collectors.groupingBy(ReferenceElement::parentId)).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> ((List)entry.getValue()).stream().map(ref -> new ReferenceDto(ref.path(), ref.collectionId(), ref.parentCollectionCode())).toList()));
    }

    @Override
    public List<ReferenceDto> getReferences(int elementId) {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Date> getProfileLastUpdates() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> getObjectsDynamicAttributesByObjectId(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        return this.dirReader.getDomain(profileCode).elements().stream().filter(element -> !element.extraAttributes().isEmpty()).collect(Collectors.toMap(element -> Integer.toString(element.id()), t -> SnapshotDomainCacheDao.buildExtraAttributes(t.extraAttributes(), t)));
    }

    @Override
    public Map<String, List<DomainCacheDao.DomainAttributeLoadWrapper>> getObjectsAttributesByObjectId(String profileCode, int sessionId, Set<Integer> userRegionVersions) {
        return this.dirReader.getDomain(profileCode).elements().stream().filter(element -> !element.attributes().isEmpty()).collect(Collectors.toMap(element -> Integer.toString(element.id()), element -> SnapshotDomainCacheDao.buildAttributes(element.attributes(), element)));
    }

    @Override
    public List<RegionVersion> getUserVersions(String profileCode, String user) {
        throw new UnsupportedOperationException("Cannot get user versions with snapshot data source");
    }

    @Override
    public List<OpenSession> getOpenSessions(String profile, String user) {
        throw new UnsupportedOperationException("Cannot get open session with snapshot data source");
    }

    @Override
    public Date getLastUpdateForProfile(String profileCode) {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public Date getLastUpdateForOpenSession(String profileCode, String user) {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public Date getDefinitionLastUpdateInProfile(String profileCode) {
        return SnapshotDataSourceConstants.YEAR_AGO;
    }

    @Override
    public SortedSet<Integer> getSystemVersionWithoutMy(String profile, SortedSet<Integer> myVersions) {
        return null;
    }

    private static DomainObjectImpl buildDomainObject(Element element, List<RegionVersion> versions, Map<String, DomainObjectTypeImpl> types) {
        DomainObjectImpl domainObject = new DomainObjectImpl(element.id(), element.code(), element.name(), element.description(), types.get(Integer.toString(element.type().id())), element.parentId(), true);
        domainObject.setIdToSelectChildren(domainObject.getId());
        if (element.versionNumber() != null) {
            domainObject.setRegion(SnapshotDomainCacheDao.getRegion(element, versions));
        }
        return domainObject;
    }

    private static RegionCached getRegion(Element element, List<RegionVersion> versions) {
        RegionVersion regionVersion = versions.stream().filter(version -> Objects.equals(version.getRegion(), element.regionCode())).filter(version -> Objects.equals(version.getNumber(), element.versionNumber())).findAny().orElseThrow(() -> new IllegalStateException("Cannot find element version " + element.versionNumber() + " Region " + element.regionCode() + ")"));
        return new RegionCached(regionVersion.getRegion(), regionVersion.getNumber(), regionVersion.getId());
    }

    private static DomainObjectTypeImpl buildType(CollectionElement element) {
        DomainObjectTypeImpl type = new DomainObjectTypeImpl(element.id(), element.code(), element.name());
        type.setCollectionType(element.collectionTypeId());
        type.setTypeCode(element.typeCode());
        type.setTypeId(element.typeId());
        type.setRootCollection(element.root());
        type.setTypeNature(element.typeNature());
        type.setOrder(element.order());
        type.setParentTypeCode(element.parentTypeCode());
        type.setMultiple(element.multiple());
        type.setVisible(element.visible());
        element.attrs().forEach(a -> type.addAttributeDefinition(new AttributeDefinitionImpl(a.attrType(), a.code(), a.name(), a.description(), a.groupName())));
        return type;
    }

    private static List<DomainCacheDao.DomainAttributeLoadWrapper> buildExtraAttributes(List<ElementAttributeExtra> attributes, Element id) {
        return attributes.stream().map(attribute -> new DomainCacheDao.DomainAttributeLoadWrapper(SnapshotDomainCacheDao.buildExtraAttribute(attribute, id), new LoadTime(0L, 0L))).toList();
    }

    private static List<DomainCacheDao.DomainAttributeLoadWrapper> buildAttributes(List<ElementAttribute> attributes, Element id) {
        return attributes.stream().map(a -> new DomainCacheDao.DomainAttributeLoadWrapper(SnapshotDomainCacheDao.buildAttribute(a, id), new LoadTime(0L, 0L))).toList();
    }

    private static DomainAttributeDto buildExtraAttribute(ElementAttributeExtra a, Element element) {
        DomainAttributeDto domainAttributeDto = new DomainAttributeDto(a.id(), element.id(), a.attrCode());
        domainAttributeDto.setType(a.refType());
        domainAttributeDto.setName(a.attrName());
        domainAttributeDto.setRawValue(a.attrValue());
        domainAttributeDto.setRawType(Type.valueOf(a.refType()));
        domainAttributeDto.setDomainType(SnapshotDomainCacheDao.buildType(element.type()));
        return domainAttributeDto;
    }

    private static DomainAttributeDto buildAttribute(ElementAttribute attribute, Element element) {
        AttributeType attributeType1 = element.type().attrs().stream().filter(attributeType -> attributeType.code().equals(attribute.attrCode())).findAny().orElseThrow();
        DomainAttributeDto domainAttributeDto = new DomainAttributeDto(attribute.id(), element.id(), attribute.attrCode());
        domainAttributeDto.setRawType(Type.valueOf(attribute.refType()));
        domainAttributeDto.setRawValue(attribute.refName());
        domainAttributeDto.setName(attributeType1.name());
        domainAttributeDto.setDescription(attributeType1.description());
        domainAttributeDto.setDomainType(SnapshotDomainCacheDao.buildType(element.type()));
        return domainAttributeDto;
    }

    public SnapshotDomainCacheDao(SnapshotDomainDirReader dirReader, VersionDao versionDao) {
        this.dirReader = dirReader;
        this.versionDao = versionDao;
    }
}

