/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.annotated.scanner;

import io.higson.runtime.engine.annotated.RepositoryObjectKey;
import io.higson.runtime.engine.annotated.annotations.ObjectInstance;
import io.higson.runtime.engine.annotated.annotations.Sortable;
import io.higson.runtime.engine.util.reflection.AnnotationHelper;
import io.higson.runtime.engine.util.reflection.ReflectionsConstructorUtil;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class AnnotatedObjectFactory {
    public static final int DEFAULT_ORDER_VALUE = 100;
    private static final String INSTANCES_METHOD_NAME = "instances";
    private static final String VALUES_METHOD_NAME = "values";
    private static final String ORDER_METHOD_NAME = "order";

    public <T> Map<RepositoryObjectKey, T> createObjects(Class<T> objectClass, Annotation annotation) {
        ObjectInstance[] instanceDescriptors = this.extractInstanceDescriptors(annotation);
        Map<String, T> rawObjectInstances = instanceDescriptors.length > 0 ? this.createObjectsFromInstanceDescriptors(objectClass, instanceDescriptors) : this.createObject(objectClass, annotation);
        int objectOrder = this.extractOrder(annotation);
        HashMap<RepositoryObjectKey, T> createdObjects = new HashMap<RepositoryObjectKey, T>();
        for (Map.Entry<String, T> objectEntry : rawObjectInstances.entrySet()) {
            createdObjects.put(new RepositoryObjectKey(objectEntry.getKey(), objectOrder), objectEntry.getValue());
        }
        return createdObjects;
    }

    private <T> Map<String, T> createObjectsFromInstanceDescriptors(Class<T> objectClass, ObjectInstance[] instanceDescriptors) {
        HashMap<String, T> createdObjects = new HashMap<String, T>();
        for (ObjectInstance instanceDescriptor : instanceDescriptors) {
            String objectIdentifier = this.extractValue(instanceDescriptor);
            T object = this.instantiateUsingObjectDescriptor(objectClass, instanceDescriptor);
            createdObjects.put(objectIdentifier, object);
        }
        return createdObjects;
    }

    private <T> Map<String, T> createObject(Class<T> objectClass, Annotation annotation) {
        String[] objectIdentifiers = this.extractIdentifiers(annotation);
        T object = this.instantiateUsingDefaultConstructor(objectClass);
        HashMap<String, T> createdObjects = new HashMap<String, T>();
        for (String objectIdentifier : objectIdentifiers) {
            createdObjects.put(objectIdentifier, object);
        }
        return createdObjects;
    }

    private <T> T instantiateUsingDefaultConstructor(Class<T> objectClass) {
        return ReflectionsConstructorUtil.createObject(objectClass);
    }

    private <T> T instantiateUsingObjectDescriptor(Class<T> objectClass, ObjectInstance objectDescriptor) {
        int constructorArgCount = objectDescriptor.constructorArgs().length;
        Class[] constructorArgClasses = new Class[constructorArgCount];
        Object[] constructorArgs = new Object[constructorArgCount];
        for (int i = 0; i < constructorArgCount; ++i) {
            String constructorArg = objectDescriptor.constructorArgs()[i];
            constructorArgClasses[i] = constructorArg.getClass();
            constructorArgs[i] = constructorArg;
        }
        return ReflectionsConstructorUtil.createObject(objectClass, constructorArgClasses, constructorArgs);
    }

    private String extractValue(Annotation annotation) {
        return (String)AnnotationHelper.extractValue(annotation, "value");
    }

    private int extractOrder(Annotation annotation) {
        if (annotation.annotationType().isAnnotationPresent(Sortable.class)) {
            return (Integer)AnnotationHelper.extractValue(annotation, ORDER_METHOD_NAME);
        }
        return 100;
    }

    private String[] extractIdentifiers(Annotation annotation) {
        String[] identifiers = (String[])AnnotationHelper.extractValue(annotation, VALUES_METHOD_NAME);
        if (identifiers.length > 0) {
            return identifiers;
        }
        return new String[]{this.extractValue(annotation)};
    }

    private ObjectInstance[] extractInstanceDescriptors(Annotation annotation) {
        return (ObjectInstance[])AnnotationHelper.extractValue(annotation, INSTANCES_METHOD_NAME);
    }
}

