/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.flow.trace;

import io.higson.runtime.flow.Action;
import io.higson.runtime.flow.Variable;
import io.higson.runtime.flow.trace.Event;
import java.util.List;

public class ActionExecutedEvent
extends Event {
    private final String nodeId;
    private final Action action;
    private final Object result;
    private final List<Variable> variables;

    public ActionExecutedEvent(String flowName, String nodeId, Action action, Object result, List<Variable> variables) {
        super(flowName);
        this.nodeId = nodeId;
        this.action = action;
        this.result = result;
        this.variables = variables;
    }

    @Override
    public String print() {
        return String.format("%s: [ %s ] action executed %s := %s/%s", new Object[]{this.getFlowName(), this.nodeId, this.output(), this.action.getType(), this.action.getValue()});
    }

    private String output() {
        return this.action.getOutputVariable();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Action getAction() {
        return this.action;
    }

    public Object getResult() {
        return this.result;
    }

    @Override
    public List<Variable> getVariables() {
        return this.variables;
    }
}

