/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.parser;

import io.higson.runtime.engine.util.EngineUtil;
import io.higson.runtime.helper.parser.LimitCache;
import java.math.BigDecimal;

public class CachingNumberParser {
    private static final LimitCache<String, BigDecimal> cache = new LimitCache("number-parser");

    public static void setCacheSize(int maxSize) {
        cache.setMaxSize(maxSize);
    }

    public static BigDecimal parse(String text) {
        BigDecimal value = cache.get(text);
        if (value == null) {
            value = CachingNumberParser.doParse(text);
            cache.put(text, value);
        }
        return value;
    }

    public static BigDecimal doParse(String text) {
        return new BigDecimal(EngineUtil.trimAllWhitespace(text).replace(',', '.'));
    }
}

