/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.helper.parser;

import io.higson.runtime.engine.util.EngineUtil;
import io.higson.runtime.helper.parser.LimitCache;

public class CachingSplitter {
    private final char separator;
    private final LimitCache<String, String[]> cache;

    public CachingSplitter(char separator, int maxSize) {
        this.separator = separator;
        this.cache = new LimitCache("splitter", maxSize);
    }

    public CachingSplitter(char separator) {
        this.separator = separator;
        this.cache = new LimitCache("splitter");
    }

    public void setCacheSize(int maxSize) {
        this.cache.setMaxSize(maxSize);
    }

    public String[] split(String text) {
        String[] tokens = this.cache.get(text);
        if (tokens == null) {
            boolean put = this.cache.isOpen();
            tokens = EngineUtil.split(text, this.separator);
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = tokens[i].trim();
                if (!put) continue;
                tokens[i] = tokens[i].intern();
            }
            if (put) {
                this.cache.put(text, tokens);
            }
        }
        return tokens;
    }

    public char separator() {
        return this.separator;
    }

    LimitCache<String, String[]> cache() {
        return this.cache;
    }
}

