/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.invoker;

import groovy.lang.Binding;
import io.higson.runtime.constants.FunctionCode;
import io.higson.runtime.engine.core.function.Function;
import io.higson.runtime.engine.core.function.FunctionInvoker;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.function.groovy.shell.CachedGroovyShell;
import io.higson.runtime.function.groovy.shell.CompiledGroovyFunction;
import io.higson.runtime.function.log.FunctionLoggerCreator;
import io.higson.runtime.model.GroovyFunction;
import io.higson.runtime.profiler.engine.EngineProfiler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyFunctionInvoker
implements FunctionInvoker {
    private static final Logger log = LoggerFactory.getLogger(GroovyFunctionInvoker.class);
    private static final EngineProfiler profiler = EngineProfiler.FUNCTION;
    private final CachedGroovyShell shell;

    public GroovyFunctionInvoker(FunctionLoggerCreator functionLoggerCreator, boolean groovySecured, boolean indy) {
        this.shell = new CachedGroovyShell(functionLoggerCreator, groovySecured, indy);
    }

    public GroovyFunctionInvoker() {
        this(new FunctionLoggerCreator(), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Function function, Object ... args) {
        long t = System.currentTimeMillis();
        try {
            GroovyFunction f = this.cast(function);
            Object object = this.call(f, args);
            return object;
        }
        finally {
            profiler.addGetMeasure(function.getName(), t, System.currentTimeMillis());
        }
    }

    private GroovyFunction cast(Function f) {
        if (f instanceof GroovyFunction) {
            return (GroovyFunction)f;
        }
        log.error("Unexpected function: {}", (Object)f);
        throw new HigsonRuntimeException("Illegal function passed to GroovyFunctionInvoker: " + f);
    }

    public void addGlobalObject(String code, Object obj) {
        log.debug("registering groovy global object: {} -> {}", (Object)code, obj);
        this.shell.setVariable(code, obj);
    }

    public void addGlobalObject(FunctionCode functionCode, Object obj) {
        log.debug("registering groovy global object: {} -> {}", (Object)functionCode, obj);
        this.shell.setVariable(functionCode.code(), obj);
    }

    public void invalidate(int implId) {
        log.debug("invalidating cc for impl.id: {}", (Object)implId);
        CompiledGroovyFunction f = this.shell.getCompileCache().remove(implId);
        if (f != null) {
            log.debug("found and invalidated: {}", (Object)f);
        } else {
            log.debug("impl not found in cc");
        }
    }

    public void invalidate() {
        log.debug("invalidating all compiled functions");
        this.shell.getCompileCache().clear();
    }

    public Map<Integer, CompiledGroovyFunction> getCompileCacheSnapshot() {
        return new HashMap<Integer, CompiledGroovyFunction>(this.shell.getCompileCache());
    }

    public Object getBoundVariable(String name) {
        return this.shell.getContext().getVariable(name);
    }

    private Object call(GroovyFunction function, Object ... passedArguments) {
        try {
            String[] declaresArgsNames = function.getArgsArray();
            Binding arguments = new Binding();
            int argumentsCount = declaresArgsNames.length;
            for (int i = 0; i < argumentsCount; ++i) {
                Object argValue = i < passedArguments.length ? passedArguments[i] : null;
                arguments.setVariable(declaresArgsNames[i], argValue);
            }
            return this.shell.evaluate(function, arguments);
        }
        catch (RuntimeException e) {
            throw new HigsonRuntimeException("Groovy function invocation error", e);
        }
    }
}

