/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.matcher;

import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.helper.parser.CachingSplitter;
import io.higson.runtime.matcher.AbstractSetMatcher;

public class InMatcher
extends AbstractSetMatcher {
    private final CachingSplitter splitter;

    public InMatcher(char separator) {
        super(separator);
        this.splitter = new CachingSplitter(separator);
    }

    public InMatcher() {
        this.splitter = new CachingSplitter(',');
    }

    public InMatcher(CachingSplitter splitter) {
        super(splitter.separator());
        this.splitter = splitter;
    }

    @Override
    public <T extends ValueHolder> boolean doMatches(String value, String pattern, Type<T> type) {
        String[] patternElements;
        if (this.isBlank(pattern) || this.isBlank(value)) {
            return false;
        }
        T v = type.decode(value);
        for (String element : patternElements = this.splitter.split(pattern)) {
            T elementHolder = type.decode(element);
            if (elementHolder.compareTo(v) != 0) continue;
            return true;
        }
        return false;
    }

    public CachingSplitter splitter() {
        return this.splitter;
    }
}

