/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler.engine;

import io.higson.runtime.profiler.CommonProfiler;
import io.higson.runtime.profiler.ProfilerStat;
import java.util.List;

public enum EngineProfiler {
    PARAMETER,
    FUNCTION;

    private final transient CommonProfiler invokeProfiler = new CommonProfiler();
    private final transient CommonProfiler loadProfiler = new CommonProfiler();

    public void addLoadMeasure(String paramName, long t1, long t2) {
        this.loadProfiler.addTime(paramName, t1, t2);
    }

    public void addGetMeasure(String uid, long t1, long t2) {
        this.invokeProfiler.addTime(uid, t1, t2);
    }

    public CommonProfiler getInvokeProfiler() {
        return this.invokeProfiler;
    }

    public CommonProfiler getLoadProfiler() {
        return this.loadProfiler;
    }

    public List<ProfilerStat> getLoadStats() {
        return this.loadProfiler.getStatistics();
    }

    public List<ProfilerStat> getInvokeStats() {
        return this.invokeProfiler.getStatistics();
    }

    public ProfilerStat getInvokeStat(String code) {
        return this.getStat(code, this.invokeProfiler);
    }

    public ProfilerStat getLoadStat(String code) {
        return this.getStat(code, this.loadProfiler);
    }

    private ProfilerStat getStat(String code, CommonProfiler profiler) {
        List stats = profiler.getStatistics();
        for (ProfilerStat stat : stats) {
            if (!((String)stat.getKey()).equals(code)) continue;
            return stat;
        }
        return new ProfilerStat(code);
    }
}

