/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler.jdbc;

public class QueryStat
implements Comparable<QueryStat> {
    private String sql;
    private int sqlUid;
    private int count;
    private long totalTime;

    public QueryStat(String sql, int sqlUid) {
        this.sql = sql;
        this.sqlUid = sqlUid;
    }

    public void addMeasure(long time) {
        ++this.count;
        this.totalTime += time;
    }

    public String getSqlTrim() {
        return this.sql.trim();
    }

    public double getAvg() {
        return (double)this.totalTime / (double)this.count;
    }

    public String toString() {
        return "QueryAggregate[sqlUid=" + this.sqlUid + ", count=" + this.count + ", time=" + this.totalTime + String.format(", avg=%.2f", (double)this.totalTime / (double)this.count) + "]";
    }

    @Override
    public int compareTo(QueryStat o) {
        return (int)(o.totalTime - this.totalTime);
    }

    public String getSql() {
        return this.sql;
    }

    public int getSqlUid() {
        return this.sqlUid;
    }

    public int getCount() {
        return this.count;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryStat)) {
            return false;
        }
        QueryStat other = (QueryStat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSqlUid() != other.getSqlUid()) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryStat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSqlUid();
        result = result * 59 + this.getCount();
        return result;
    }
}

