/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.prepared;

import java.util.Arrays;
import org.smartparam.engine.core.parameter.ParameterEntry;

public class PreparedEntry {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final String[] levels;

    public PreparedEntry(ParameterEntry parameterEntry) {
        this.levels = this.normalizeLevels(parameterEntry.getLevels());
    }

    public String[] getLevels() {
        return this.levels;
    }

    private String[] normalizeLevels(String[] rawLevels) {
        String[] normalizedLevels = this.trimRight(rawLevels);
        this.internalizeLevelValues(normalizedLevels);
        return normalizedLevels;
    }

    private String[] trimRight(String[] array) {
        int len;
        if (array == null) {
            return EMPTY_ARRAY;
        }
        for (len = array.length; len > 0 && array[len - 1] == null; --len) {
        }
        return len < array.length ? Arrays.copyOf(array, len) : array;
    }

    private void internalizeLevelValues(String[] levels) {
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i] == null) continue;
            levels[i] = levels[i].intern();
        }
    }

    public String getLevel(int k) {
        return k >= 1 && k <= this.levels.length ? this.levels[k - 1] : null;
    }
}

