/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.rhino.value;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.smartparam.engine.core.output.MultiValue;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.runtime.helper.TypeConverter;

public class RhinoMultiValue {
    private final MultiValue row;
    private static final TypeConverter type = TypeConverter.getInstance();

    public RhinoMultiValue(MultiValue row) {
        this.row = row;
    }

    public ValueHolder getHolder(int position) {
        return this.row.getHolder(position);
    }

    public ValueHolder getHolder(String name) {
        return this.row.getHolder(name);
    }

    public ValueHolder getHolder() {
        return this.getHolder(0);
    }

    public <T> T get(int position) {
        return this.row.get(position);
    }

    public <T> T get(int position, Class<T> clazz) {
        return this.row.get(position, clazz);
    }

    public <T> T get(String name) {
        return this.row.get(name);
    }

    public <T> T get(String name, Class<T> clazz) {
        return this.row.get(name, clazz);
    }

    public <T> T get() {
        return this.get(0);
    }

    public double getNumber(int position) {
        return type.getNumber(this.getHolder(position));
    }

    public double getNumber(String name) {
        return type.getNumber(this.getHolder(name));
    }

    public double getNumber() {
        return this.getNumber(0);
    }

    public Integer getInteger(int position) {
        return type.getInteger(this.getHolder(position));
    }

    public Integer getInteger(String name) {
        return type.getInteger(this.getHolder(name));
    }

    public Integer getInteger() {
        return this.getInteger(0);
    }

    public Long getLong(int position) {
        return type.getLong(this.getHolder(position));
    }

    public Long getLong(String name) {
        return type.getLong(this.getHolder(name));
    }

    public Long getLong() {
        return this.getLong(0);
    }

    public BigDecimal getDecimal(int position) {
        return type.getDecimal(this.getHolder(position));
    }

    public BigDecimal getDecimal(String name) {
        return type.getDecimal(this.getHolder(name));
    }

    public BigDecimal getDecimal() {
        return this.getDecimal(0);
    }

    public BigDecimal getBigDecimal(int position) {
        return this.getDecimal(position);
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getDecimal(name);
    }

    public BigDecimal getBigDecimal() {
        return this.getDecimal();
    }

    public Date getDate(int position) {
        return type.getDate(this.getHolder(position));
    }

    public Date getDate(String name) {
        return type.getDate(this.getHolder(name));
    }

    public Date getDate() {
        return this.getDate(0);
    }

    public Date getDatetime(int position) {
        return type.getDatetime(this.getHolder(position));
    }

    public Date getDatetime(String name) {
        return type.getDatetime(this.getHolder(name));
    }

    public Date getDatetime() {
        return this.getDatetime(0);
    }

    public boolean getBoolean(int position) {
        return type.getBoolean(this.getHolder(position));
    }

    public boolean getBoolean(String name) {
        return type.getBoolean(this.getHolder(name));
    }

    public boolean getBoolean() {
        return this.getBoolean(0);
    }

    public String getString(int position) {
        return this.row.getString(position);
    }

    public String getString(String name) {
        return this.row.getString(name);
    }

    public String getString() {
        return this.getString(0);
    }

    public <T extends Enum<T>> T getEnum(int position, Class<T> enumClass) {
        return this.row.getEnum(position, enumClass);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass) {
        return this.row.getEnum(name, enumClass);
    }

    public ValueHolder[] getArray(int position) {
        return this.row.getArray(position);
    }

    public ValueHolder[] getArray() {
        return this.getArray(0);
    }

    public Object[] unwrap() {
        return this.row.unwrap();
    }

    public MultiValue raw() {
        return this.row;
    }

    public String[] getStringArray(int position) {
        return this.row.getStringArray(position);
    }

    public String[] getStringArray(String name) {
        return this.row.getStringArray(name);
    }

    public String[] getStringArray() {
        return this.getStringArray(0);
    }

    public List<String> getStringList(int position) {
        return Arrays.asList(this.getStringArray(position));
    }

    public List<String> getStringList(String name) {
        return Arrays.asList(this.getStringArray(name));
    }

    public List<String> getStringList() {
        return this.getStringList(0);
    }

    public Date[] getDateArray(int position) {
        return this.row.getDateArray(position);
    }

    public Date[] getDateArray(String name) {
        return this.row.getDateArray(name);
    }

    public Date[] getDateArray() {
        return this.getDateArray(0);
    }

    public List<Date> getDateList(int position) {
        return Arrays.asList(this.getDateArray(position));
    }

    public List<Date> getDateList(String name) {
        return Arrays.asList(this.getDateArray(name));
    }

    public List<Date> getDateList() {
        return this.getDateList(0);
    }

    public Integer[] getIntegerArray(int position) {
        return this.row.getIntegerArray(position);
    }

    public Integer[] getIntegerArray(String name) {
        return this.row.getIntegerArray(name);
    }

    public Integer[] getIntegerArray() {
        return this.getIntegerArray(0);
    }

    public List<Integer> getIntegerList(int position) {
        return Arrays.asList(this.getIntegerArray(position));
    }

    public List<Integer> getIntegerList(String name) {
        return Arrays.asList(this.getIntegerArray(name));
    }

    public List<Integer> getIntegerList() {
        return Arrays.asList(this.getIntegerArray());
    }

    public double[] getNumberArray(int position) {
        return this.toNumberArray(this.row.getArray(position));
    }

    public double[] getNumberArray(String name) {
        return this.toNumberArray(this.row.getArray(name));
    }

    public double[] getNumberArray() {
        return this.toNumberArray(this.row.getArray(0));
    }

    public List<Double> getNumberList(int position) {
        return this.toNumberList(this.row.getArray(position));
    }

    public List<Double> getNumberList(String name) {
        return this.toNumberList(this.row.getArray(name));
    }

    public List<Double> getNumberList() {
        return this.toNumberList(this.row.getArray(0));
    }

    public BigDecimal[] getDecimalArray(int position) {
        return this.row.getBigDecimalArray(position);
    }

    public BigDecimal[] getDecimalArray(String name) {
        return this.row.getBigDecimalArray(name);
    }

    public BigDecimal[] getDecimalArray() {
        return this.getDecimalArray(0);
    }

    public List<BigDecimal> getDecimalList(int position) {
        return this.toDecimalList(this.row.getArray(position));
    }

    public List<BigDecimal> getDecimalList(String name) {
        return this.toDecimalList(this.row.getArray(name));
    }

    public List<BigDecimal> getDecimalList() {
        return this.getDecimalList(0);
    }

    public double[] toNumberArray(ValueHolder[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = type.getNumber(array[i]);
        }
        return result;
    }

    public List<Double> toNumberList(ValueHolder[] array) {
        ArrayList<Double> result = new ArrayList<Double>(array.length);
        for (ValueHolder e : array) {
            result.add(type.getNumber(e));
        }
        return result;
    }

    public List<BigDecimal> toDecimalList(ValueHolder[] array) {
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(array.length);
        for (ValueHolder e : array) {
            result.add(type.getDecimal(e));
        }
        return result;
    }

    public Long[] getLongArray(int position) {
        return this.row.getLongArray(position);
    }

    public BigDecimal[] getBigDecimalArray(int position) {
        return this.row.getBigDecimalArray(position);
    }

    public ValueHolder[] getArray(String name) {
        return this.row.getArray(name);
    }

    public BigDecimal[] getBigDecimalArray(String name) {
        return this.row.getBigDecimalArray(name);
    }

    public Long[] getLongArray(String name) {
        return this.row.getLongArray(name);
    }

    public String toString() {
        return this.row.toString();
    }

    public String toStringInline() {
        return this.row.toStringInline();
    }

    public int size() {
        return this.row.size();
    }

    public boolean isBlank() {
        return this.row.isBlank();
    }
}

