/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.logger;

import com.google.common.base.Splitter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.common.logger.ConfigurationLoggerSection;
import pl.decerto.hyperon.common.utils.PropertyProvider;

class ExternalDatasourceConfigurationLoggerSection
implements ConfigurationLoggerSection {
    private final PropertyProvider propertyProvider;

    @Override
    public String getName() {
        return "External datasource";
    }

    @Override
    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        String datasourceNames = StringUtils.defaultString((String)this.propertyProvider.getProperty("higson.runtime.external-datasource.sql.names"));
        properties.put("Configured external datasource's names", datasourceNames);
        List splitDatasourceNames = Splitter.on((String)",").trimResults().splitToList((CharSequence)datasourceNames);
        for (String datasourceName : splitDatasourceNames) {
            String url = this.propertyProvider.getProperty("higson.runtime.external-datasource.sql.%s.url".formatted(datasourceName));
            String user = this.propertyProvider.getProperty("higson.runtime.external-datasource.sql.%s.username".formatted(datasourceName));
            properties.put("Datasource %s URL".formatted(datasourceName), StringUtils.defaultString((String)url));
            properties.put("Datasource %s username".formatted(datasourceName), StringUtils.defaultString((String)user));
        }
        return properties;
    }

    public ExternalDatasourceConfigurationLoggerSection(PropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider;
    }
}

