/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.LoginEventService;
import pl.decerto.hyperon.common.security.dao.LoginEventDao;
import pl.decerto.hyperon.common.security.domain.LoginEvent;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.mapper.SystemUserFullMapper;

@Service
public class LoginEventServiceImpl
implements LoginEventService {
    private final LoginEventDao dao;
    private final SystemUserFullMapper userMapper;

    @Autowired
    public LoginEventServiceImpl(LoginEventDao dao, SystemUserFullMapper userMapper) {
        this.dao = dao;
        this.userMapper = userMapper;
    }

    @Override
    @Transactional
    public List<LoginEvent> getLoginEvents(Integer userId) {
        return this.dao.findByUserId(userId);
    }

    @Override
    @Transactional
    public void saveLoginEvent(SystemUser user, LoginEvent.Type result) {
        LoginEvent event = new LoginEvent();
        event.setDate(new Date());
        event.setUser(this.userMapper.toModel(user));
        event.setResult(result);
        this.dao.save(event);
    }
}

