/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import java.time.LocalDateTime;
import pl.decerto.hyperon.common.persistence.jpa.BaseEntity;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.domain.TokenType;

@Entity
public class JwtToken
extends BaseEntity {
    @Id
    @SequenceGenerator(name="jwttoken_id_generator", sequenceName="SEQ_JWT_TOKEN")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="jwttoken_id_generator")
    private int id;
    @Column(nullable=false)
    private String token;
    @Column(name="create_date", nullable=false)
    private LocalDateTime createDate;
    @Column(name="expiration_date", nullable=false)
    private LocalDateTime expirationDate;
    @Enumerated(value=EnumType.STRING)
    @Column(name="token_type", nullable=false, updatable=false, length=30)
    private TokenType tokenType;
    @ManyToOne
    @JoinColumn(name="user_id")
    private SystemUserJPA user;

    public void setId(int id) {
        this.id = id;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public void setExpirationDate(LocalDateTime expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public void setUser(SystemUserJPA user) {
        this.user = user;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public LocalDateTime getCreateDate() {
        return this.createDate;
    }

    public LocalDateTime getExpirationDate() {
        return this.expirationDate;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public SystemUserJPA getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtToken)) {
            return false;
        }
        JwtToken other = (JwtToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        LocalDateTime this$createDate = this.getCreateDate();
        LocalDateTime other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        LocalDateTime this$expirationDate = this.getExpirationDate();
        LocalDateTime other$expirationDate = other.getExpirationDate();
        if (this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate)) {
            return false;
        }
        TokenType this$tokenType = this.getTokenType();
        TokenType other$tokenType = other.getTokenType();
        return !(this$tokenType == null ? other$tokenType != null : !((Object)((Object)this$tokenType)).equals((Object)other$tokenType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        LocalDateTime $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        LocalDateTime $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        TokenType $tokenType = this.getTokenType();
        result = result * 59 + ($tokenType == null ? 43 : ((Object)((Object)$tokenType)).hashCode());
        return result;
    }
}

