/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.dto;

import jakarta.validation.constraints.Size;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import pl.decerto.hyperon.common.security.dto.SystemRightDto;
import pl.decerto.hyperon.common.security.dto.SystemUser;

public class SystemRole {
    public static final Comparator<SystemRole> ROLE_BY_CODE_ORDER = Comparator.comparing(SystemRole::getCode);
    private static final int MAX_DESCRIPTION_LENGTH = 255;
    public static final String PROPERTY_CODE = "code";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_CREATE_DATE = "createDate";
    public static final String PROPERTY_USERS = "users";
    public static final String PROPERTY_RIGHTS = "rights";
    private int id;
    @Size(min=1, max=100, message="{common.incorrect.name.length}")
    private @Size(min=1, max=100, message="{common.incorrect.name.length}") String code = "";
    @Size(max=255, message="{common.incorrectDescription}")
    private @Size(max=255, message="{common.incorrectDescription}") String description = "";
    private Date createDate;
    private Set<SystemUser> users = new HashSet<SystemUser>();
    private Set<SystemRightDto> rights = new HashSet<SystemRightDto>();

    public void addUser(SystemUser userDto) {
        this.users.add(userDto);
    }

    public void addRight(SystemRightDto rightDto) {
        this.rights.add(rightDto);
    }

    public boolean isNewObject() {
        return this.getId() == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemRole other = (SystemRole)obj;
        return this.id == other.id;
    }

    public SystemRole copy() {
        SystemRole sr = new SystemRole();
        sr.setId(this.id);
        sr.setCode(this.code);
        sr.setDescription(this.description);
        sr.setCreateDate(this.createDate);
        return sr;
    }

    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Set<SystemUser> getUsers() {
        return this.users;
    }

    public Set<SystemRightDto> getRights() {
        return this.rights;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setUsers(Set<SystemUser> users) {
        this.users = users;
    }

    public void setRights(Set<SystemRightDto> rights) {
        this.rights = rights;
    }

    public String toString() {
        return "SystemRole(id=" + this.getId() + ", code=" + this.getCode() + ", description=" + this.getDescription() + ", createDate=" + this.getCreateDate() + ", users=" + this.getUsers() + ", rights=" + this.getRights() + ")";
    }
}

