/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.caffeine.CaffeineCache;
import pl.decerto.hyperon.rest.cache.RestApiCacheManager;

public class RestApiCacheManagerBuilder {
    private static final Logger log = LoggerFactory.getLogger(RestApiCacheManagerBuilder.class);
    private final Map<String, Caffeine<Object, Object>> builders = new HashMap<String, Caffeine<Object, Object>>();
    private Caffeine<Object, Object> defaultBuilder;

    public RestApiCacheManagerBuilder withCache(String name, Caffeine<Object, Object> builder) {
        this.builders.put(name, builder);
        return this;
    }

    public RestApiCacheManagerBuilder withDefault(Caffeine<Object, Object> builder) {
        this.defaultBuilder = builder;
        return this;
    }

    public RestApiCacheManager build() {
        this.logConfigurations();
        List caches = this.builders.entrySet().stream().map(entry -> new CaffeineCache((String)entry.getKey(), ((Caffeine)entry.getValue()).build())).collect(Collectors.toList());
        RestApiCacheManager cm = new RestApiCacheManager();
        cm.setCaches(caches);
        cm.setDefaultBuilder(this.defaultBuilder);
        return cm;
    }

    private void logConfigurations() {
        int maxLength = this.builders.keySet().stream().mapToInt(String::length).max().orElse(0);
        log.info("creating RestApiCacheManager with following caches:");
        for (Map.Entry<String, Caffeine<Object, Object>> entry : this.builders.entrySet()) {
            log.info("[ {} ] -> {}", (Object)StringUtils.rightPad((String)entry.getKey(), (int)maxLength), entry.getValue());
        }
        log.info("[ {} ] -> {}", (Object)StringUtils.rightPad((String)"default", (int)maxLength), this.defaultBuilder);
    }
}

