/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import io.higson.runtime.sql.dialect.DialectParser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DatabaseProperties {
    private final String dialect;
    private final String dbUsername;
    private final String dbPassword;
    private final String dbUrl;

    public DatabaseProperties(@Value(value="${higson.database.dialect:#{null}}") String dialect, @Value(value="${higson.database.username}") String dbUsername, @Value(value="${higson.database.password}") String dbPassword, @Value(value="${higson.database.url}") String dbUrl) {
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.dbUrl = dbUrl;
        this.dialect = DialectParser.getDatabaseDialect((String)dbUrl, (String)dialect);
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseProperties)) {
            return false;
        }
        DatabaseProperties other = (DatabaseProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dialect = this.getDialect();
        String other$dialect = other.getDialect();
        if (this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect)) {
            return false;
        }
        String this$dbUsername = this.getDbUsername();
        String other$dbUsername = other.getDbUsername();
        if (this$dbUsername == null ? other$dbUsername != null : !this$dbUsername.equals(other$dbUsername)) {
            return false;
        }
        String this$dbPassword = this.getDbPassword();
        String other$dbPassword = other.getDbPassword();
        if (this$dbPassword == null ? other$dbPassword != null : !this$dbPassword.equals(other$dbPassword)) {
            return false;
        }
        String this$dbUrl = this.getDbUrl();
        String other$dbUrl = other.getDbUrl();
        return !(this$dbUrl == null ? other$dbUrl != null : !this$dbUrl.equals(other$dbUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dialect = this.getDialect();
        result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
        String $dbUsername = this.getDbUsername();
        result = result * 59 + ($dbUsername == null ? 43 : $dbUsername.hashCode());
        String $dbPassword = this.getDbPassword();
        result = result * 59 + ($dbPassword == null ? 43 : $dbPassword.hashCode());
        String $dbUrl = this.getDbUrl();
        result = result * 59 + ($dbUrl == null ? 43 : $dbUrl.hashCode());
        return result;
    }
}

