/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration.security;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.web.SecurityFilterChain;
import pl.decerto.hyperon.common.security.SystemRoleManagementService;
import pl.decerto.hyperon.common.security.UserManagementService;
import pl.decerto.hyperon.common.security.activedirectory.ActiveDirectoryUserDetailsMapper;
import pl.decerto.hyperon.common.security.activedirectory.ActiveDirectoryUserDetailsValidator;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
@ConditionalOnProperty(name={"higson.runtime-rest.security.type"}, havingValue="active-directory")
public class ActiveDirectorySecurityConfiguration {
    @Value(value="${higson.security.active-directory.domain}")
    private String domain;
    @Value(value="${higson.security.active-directory.url}")
    private String url;
    @Value(value="${higson.security.active-directory.root-dn}")
    private String rootDn;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http, AuthenticationProvider daoAuthenticationProvider) throws Exception {
        return (SecurityFilterChain)http.csrf(AbstractHttpConfigurer::disable).cors(AbstractHttpConfigurer::disable).sessionManagement(configurer -> configurer.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authenticationProvider(daoAuthenticationProvider).authorizeHttpRequests(requestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requestMatcherRegistry.requestMatchers(new String[]{"/api/v3/api-docs/**", "/swagger-ui/**", "/actuator/**"})).permitAll().anyRequest()).authenticated()).httpBasic(Customizer.withDefaults()).logout(configurer -> configurer.invalidateHttpSession(true)).build();
    }

    @Bean
    AuthenticationProvider ldapAuthenticationProvider(UserDetailsContextMapper userDetailsContextMapper) {
        ActiveDirectoryLdapAuthenticationProvider provider = new ActiveDirectoryLdapAuthenticationProvider(this.domain, this.url, this.rootDn);
        provider.setUserDetailsContextMapper(userDetailsContextMapper);
        return provider;
    }

    @Bean
    UserDetailsContextMapper userDetailsContextMapper(UserManagementService userManagementServiceImpl, SystemRoleManagementService systemRoleManagementServiceImpl, UsersCacheManager usersCacheManager, ActiveDirectoryUserDetailsValidator activeDirectoryUserDetailsValidator) {
        return new ActiveDirectoryUserDetailsMapper(userManagementServiceImpl, systemRoleManagementServiceImpl, usersCacheManager, activeDirectoryUserDetailsValidator);
    }
}

