/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import com.p6spy.engine.spy.JdbcEventListenerFactory;
import com.p6spy.engine.spy.P6DataSource;
import javax.sql.DataSource;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceDecorator;
import org.springframework.core.Ordered;

public class P6SpyDataSourceDecorator
implements DataSourceDecorator,
Ordered {
    public static final int ORDER = 30;
    private final JdbcEventListenerFactory jdbcEventListenerFactory;

    public P6SpyDataSourceDecorator(JdbcEventListenerFactory jdbcEventListenerFactory) {
        this.jdbcEventListenerFactory = jdbcEventListenerFactory;
    }

    @Override
    public DataSource decorate(String beanName, DataSource dataSource) {
        P6DataSource p6DataSource = new P6DataSource(dataSource);
        p6DataSource.setJdbcEventListenerFactory(this.jdbcEventListenerFactory);
        return p6DataSource;
    }

    public int getOrder() {
        return 30;
    }
}

