/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.parameterstore;

import io.awspring.cloud.autoconfigure.config.parameterstore.ParameterStoreProperties;
import io.awspring.cloud.autoconfigure.config.reload.ConfigurationChangeDetector;
import io.awspring.cloud.autoconfigure.config.reload.ConfigurationUpdateStrategy;
import io.awspring.cloud.autoconfigure.config.reload.PollingAwsPropertySourceChangeDetector;
import io.awspring.cloud.parameterstore.ParameterStorePropertySource;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.commons.util.TaskSchedulerWrapper;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@AutoConfiguration
@EnableConfigurationProperties(value={ParameterStoreProperties.class})
@ConditionalOnClass(value={EndpointAutoConfiguration.class, RestartEndpoint.class, ContextRefresher.class})
@AutoConfigureAfter(value={InfoEndpointAutoConfiguration.class, RefreshEndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.aws.parameterstore.reload.strategy"})
@ConditionalOnBean(value={ContextRefresher.class})
public class ParameterStoreReloadAutoConfiguration {
    @Bean(value={"parameterStoreTaskScheduler"})
    @ConditionalOnMissingBean
    public TaskSchedulerWrapper<TaskScheduler> taskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setThreadNamePrefix("spring-cloud-aws-parameterstore-ThreadPoolTaskScheduler-");
        threadPoolTaskScheduler.setDaemon(true);
        return new TaskSchedulerWrapper((TaskScheduler)threadPoolTaskScheduler);
    }

    @Bean(value={"parameterStoreConfigurationUpdateStrategy"})
    @ConditionalOnMissingBean(name={"parameterStoreConfigurationUpdateStrategy"})
    public ConfigurationUpdateStrategy parameterStoreConfigurationUpdateStrategy(ParameterStoreProperties properties, Optional<RestartEndpoint> restarter, ContextRefresher refresher) {
        return ConfigurationUpdateStrategy.create(properties.getReload(), refresher, restarter);
    }

    @Bean
    @ConditionalOnBean(value={ConfigurationUpdateStrategy.class})
    public ConfigurationChangeDetector<ParameterStorePropertySource> parameterStorePollingAwsPropertySourceChangeDetector(ParameterStoreProperties properties, @Qualifier(value="parameterStoreConfigurationUpdateStrategy") ConfigurationUpdateStrategy strategy, @Qualifier(value="parameterStoreTaskScheduler") TaskSchedulerWrapper<TaskScheduler> taskScheduler, ConfigurableEnvironment environment) {
        return new PollingAwsPropertySourceChangeDetector<ParameterStorePropertySource>(properties.getReload(), ParameterStorePropertySource.class, strategy, taskScheduler.getTaskScheduler(), environment);
    }
}

