/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.decerto.hyperon.rest.cache.RestApiCacheManagerBuilder;

@Configuration
@EnableCaching
public class CacheConfiguration {
    @Bean
    public CacheManager cacheManager() {
        return new RestApiCacheManagerBuilder().withCache("jwt-load-user", this.ttl(1000, 15, TimeUnit.SECONDS)).withCache("jwt-load-token", this.ttl(1000, 15, TimeUnit.SECONDS)).withCache("jwt-parse-token", this.ttl(1000, 24, TimeUnit.HOURS)).build();
    }

    private Caffeine<Object, Object> ttl(int size, int ttl, TimeUnit unit) {
        return Caffeine.newBuilder().maximumSize((long)size).expireAfterWrite((long)ttl, unit);
    }
}

