/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.rest.configuration;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="higson")
public class HyperonEngineProperties
implements InitializingBean {
    private Runtime runtime = new Runtime();

    private static void validate(boolean devMode, String devUserName) {
        if (devMode && devUserName == null) {
            throw new IllegalArgumentException("The higson.runtime.username property is required when running with higson.runtime.dev-mode-enabled=true");
        }
    }

    public void afterPropertiesSet() {
        HyperonEngineProperties.validate(this.runtime.devModeEnabled, this.runtime.username);
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperonEngineProperties)) {
            return false;
        }
        HyperonEngineProperties other = (HyperonEngineProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Runtime this$runtime = this.getRuntime();
        Runtime other$runtime = other.getRuntime();
        return !(this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperonEngineProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Runtime $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        return result;
    }

    public String toString() {
        return "HyperonEngineProperties(runtime=" + this.getRuntime() + ")";
    }

    public static class Runtime {
        private boolean enabled;
        private boolean devModeEnabled = false;
        private String username = null;
        private int maxConcurrentLoads = 3;
        private Watcher watcher = new Watcher();
        private Function function = new Function();
        private Normalization normalization = new Normalization();
        private Groovy groovy = new Groovy();

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDevModeEnabled() {
            return this.devModeEnabled;
        }

        public String getUsername() {
            return this.username;
        }

        public int getMaxConcurrentLoads() {
            return this.maxConcurrentLoads;
        }

        public Watcher getWatcher() {
            return this.watcher;
        }

        public Function getFunction() {
            return this.function;
        }

        public Normalization getNormalization() {
            return this.normalization;
        }

        public Groovy getGroovy() {
            return this.groovy;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDevModeEnabled(boolean devModeEnabled) {
            this.devModeEnabled = devModeEnabled;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setMaxConcurrentLoads(int maxConcurrentLoads) {
            this.maxConcurrentLoads = maxConcurrentLoads;
        }

        public void setWatcher(Watcher watcher) {
            this.watcher = watcher;
        }

        public void setFunction(Function function) {
            this.function = function;
        }

        public void setNormalization(Normalization normalization) {
            this.normalization = normalization;
        }

        public void setGroovy(Groovy groovy) {
            this.groovy = groovy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Runtime)) {
                return false;
            }
            Runtime other = (Runtime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.isDevModeEnabled() != other.isDevModeEnabled()) {
                return false;
            }
            if (this.getMaxConcurrentLoads() != other.getMaxConcurrentLoads()) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            Watcher this$watcher = this.getWatcher();
            Watcher other$watcher = other.getWatcher();
            if (this$watcher == null ? other$watcher != null : !((Object)this$watcher).equals(other$watcher)) {
                return false;
            }
            Function this$function = this.getFunction();
            Function other$function = other.getFunction();
            if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
                return false;
            }
            Normalization this$normalization = this.getNormalization();
            Normalization other$normalization = other.getNormalization();
            if (this$normalization == null ? other$normalization != null : !((Object)this$normalization).equals(other$normalization)) {
                return false;
            }
            Groovy this$groovy = this.getGroovy();
            Groovy other$groovy = other.getGroovy();
            return !(this$groovy == null ? other$groovy != null : !((Object)this$groovy).equals(other$groovy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Runtime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isDevModeEnabled() ? 79 : 97);
            result = result * 59 + this.getMaxConcurrentLoads();
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            Watcher $watcher = this.getWatcher();
            result = result * 59 + ($watcher == null ? 43 : ((Object)$watcher).hashCode());
            Function $function = this.getFunction();
            result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
            Normalization $normalization = this.getNormalization();
            result = result * 59 + ($normalization == null ? 43 : ((Object)$normalization).hashCode());
            Groovy $groovy = this.getGroovy();
            result = result * 59 + ($groovy == null ? 43 : ((Object)$groovy).hashCode());
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Runtime(enabled=" + this.isEnabled() + ", devModeEnabled=" + this.isDevModeEnabled() + ", username=" + this.getUsername() + ", maxConcurrentLoads=" + this.getMaxConcurrentLoads() + ", watcher=" + this.getWatcher() + ", function=" + this.getFunction() + ", normalization=" + this.getNormalization() + ", groovy=" + this.getGroovy() + ")";
        }
    }

    public static class Watcher {
        private int pauseSeconds = 3;
        private int forceSyncSeconds = 60;

        public int getPauseSeconds() {
            return this.pauseSeconds;
        }

        public int getForceSyncSeconds() {
            return this.forceSyncSeconds;
        }

        public void setPauseSeconds(int pauseSeconds) {
            this.pauseSeconds = pauseSeconds;
        }

        public void setForceSyncSeconds(int forceSyncSeconds) {
            this.forceSyncSeconds = forceSyncSeconds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Watcher)) {
                return false;
            }
            Watcher other = (Watcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPauseSeconds() != other.getPauseSeconds()) {
                return false;
            }
            return this.getForceSyncSeconds() == other.getForceSyncSeconds();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Watcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPauseSeconds();
            result = result * 59 + this.getForceSyncSeconds();
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Watcher(pauseSeconds=" + this.getPauseSeconds() + ", forceSyncSeconds=" + this.getForceSyncSeconds() + ")";
        }
    }

    public static class Groovy {
        private boolean secured = true;

        public boolean isSecured() {
            return this.secured;
        }

        public void setSecured(boolean secured) {
            this.secured = secured;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Groovy)) {
                return false;
            }
            Groovy other = (Groovy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isSecured() == other.isSecured();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Groovy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSecured() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Groovy(secured=" + this.isSecured() + ")";
        }
    }

    public static class Normalization {
        private boolean throwOnException = false;

        public boolean isThrowOnException() {
            return this.throwOnException;
        }

        public void setThrowOnException(boolean throwOnException) {
            this.throwOnException = throwOnException;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Normalization)) {
                return false;
            }
            Normalization other = (Normalization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isThrowOnException() == other.isThrowOnException();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Normalization;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isThrowOnException() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Normalization(throwOnException=" + this.isThrowOnException() + ")";
        }
    }

    public static class Function {
        private boolean validateArguments = false;

        public boolean isValidateArguments() {
            return this.validateArguments;
        }

        public void setValidateArguments(boolean validateArguments) {
            this.validateArguments = validateArguments;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Function)) {
                return false;
            }
            Function other = (Function)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isValidateArguments() == other.isValidateArguments();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Function;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValidateArguments() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "HyperonEngineProperties.Function(validateArguments=" + this.isValidateArguments() + ")";
        }
    }
}

