/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.dynamodb;

import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.dynamodb.DaxProperties;
import io.awspring.cloud.autoconfigure.dynamodb.DynamoDbProperties;
import io.awspring.cloud.dynamodb.DefaultDynamoDbTableNameResolver;
import io.awspring.cloud.dynamodb.DefaultDynamoDbTableSchemaResolver;
import io.awspring.cloud.dynamodb.DynamoDbOperations;
import io.awspring.cloud.dynamodb.DynamoDbTableNameResolver;
import io.awspring.cloud.dynamodb.DynamoDbTableSchemaResolver;
import io.awspring.cloud.dynamodb.DynamoDbTemplate;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.dax.ClusterDaxClient;
import software.amazon.dax.Configuration;

@AutoConfiguration
@EnableConfigurationProperties(value={DynamoDbProperties.class})
@ConditionalOnClass(value={DynamoDbClient.class, DynamoDbEnhancedClient.class, DynamoDbTemplate.class})
@AutoConfigureAfter(value={CredentialsProviderAutoConfiguration.class, RegionProviderAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cloud.aws.dynamodb.enabled"}, havingValue="true", matchIfMissing=true)
public class DynamoDbAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public DynamoDbEnhancedClient dynamoDbEnhancedClient(DynamoDbClient dynamoDbClient) {
        return DynamoDbEnhancedClient.builder().dynamoDbClient(dynamoDbClient).build();
    }

    @ConditionalOnMissingBean(value={DynamoDbOperations.class})
    @Bean
    public DynamoDbTemplate dynamoDBTemplate(DynamoDbProperties properties, DynamoDbEnhancedClient dynamoDbEnhancedClient, Optional<DynamoDbTableSchemaResolver> tableSchemaResolver, Optional<DynamoDbTableNameResolver> tableNameResolver) {
        DynamoDbTableSchemaResolver tableSchemaRes = tableSchemaResolver.orElseGet(DefaultDynamoDbTableSchemaResolver::new);
        DynamoDbTableNameResolver tableNameRes = tableNameResolver.orElseGet(() -> new DefaultDynamoDbTableNameResolver(properties.getTablePrefix()));
        return new DynamoDbTemplate(dynamoDbEnhancedClient, tableSchemaRes, tableNameRes);
    }

    static class MissingDaxUrlCondition
    extends NoneNestedConditions {
        MissingDaxUrlCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"spring.cloud.aws.dynamodb.dax.url"})
        static class DynamoDbDaxUrlPropertyCondition {
            DynamoDbDaxUrlPropertyCondition() {
            }
        }
    }

    @Conditional(value={MissingDaxUrlCondition.class})
    @Configuration(proxyBeanMethods=false)
    static class StandardDynamoDbClient {
        StandardDynamoDbClient() {
        }

        @ConditionalOnMissingBean
        @Bean
        public DynamoDbClient dynamoDbClient(AwsClientBuilderConfigurer awsClientBuilderConfigurer, ObjectProvider<AwsClientCustomizer<DynamoDbClientBuilder>> configurer, DynamoDbProperties properties) {
            return (DynamoDbClient)awsClientBuilderConfigurer.configure(DynamoDbClient.builder(), properties, (AwsClientCustomizer)configurer.getIfAvailable()).build();
        }
    }

    @ConditionalOnProperty(name={"spring.cloud.aws.dynamodb.dax.url"})
    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"software.amazon.dax.ClusterDaxClient"})
    static class DaxDynamoDbClient {
        DaxDynamoDbClient() {
        }

        @ConditionalOnMissingBean
        @Bean
        public DynamoDbClient dynamoDbClient(DynamoDbProperties properties, AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider) throws IOException {
            DaxProperties daxProperties = properties.getDax();
            PropertyMapper propertyMapper = PropertyMapper.get();
            Configuration.Builder configuration = software.amazon.dax.Configuration.builder();
            propertyMapper.from((Object)daxProperties.getIdleTimeoutMillis()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).idleTimeoutMillis(arg_0));
            propertyMapper.from((Object)daxProperties.getConnectionTtlMillis()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).connectionTtlMillis(arg_0));
            propertyMapper.from((Object)daxProperties.getConnectTimeoutMillis()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).connectTimeoutMillis(arg_0));
            propertyMapper.from((Object)daxProperties.getRequestTimeoutMillis()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).requestTimeoutMillis(arg_0));
            propertyMapper.from((Object)daxProperties.getWriteRetries()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).writeRetries(arg_0));
            propertyMapper.from((Object)daxProperties.getReadRetries()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).readRetries(arg_0));
            propertyMapper.from((Object)daxProperties.getClusterUpdateIntervalMillis()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).clusterUpdateIntervalMillis(arg_0));
            propertyMapper.from((Object)daxProperties.getEndpointRefreshTimeoutMillis()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).endpointRefreshTimeoutMillis(arg_0));
            propertyMapper.from((Object)daxProperties.getMaxConcurrency()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).maxConcurrency(arg_0));
            propertyMapper.from((Object)daxProperties.getMaxPendingConnectionAcquires()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).maxPendingConnectionAcquires(arg_0));
            propertyMapper.from((Object)daxProperties.getSkipHostNameVerification()).whenNonNull().to(arg_0 -> ((Configuration.Builder)configuration).skipHostNameVerification(arg_0));
            configuration.region(AwsClientBuilderConfigurer.resolveRegion(properties, regionProvider)).credentialsProvider(credentialsProvider).url(properties.getDax().getUrl());
            return (DynamoDbClient)ClusterDaxClient.builder().overrideConfiguration(configuration.build()).build();
        }
    }
}

