/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.external;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import io.higson.runtime.engine.util.EngineUtil;
import io.higson.runtime.profiler.jdbc.proxy.DataSourceProxy;
import io.higson.runtime.sql.DialectRegistry;
import io.higson.runtime.sql.RuntimeDialect;
import io.higson.runtime.sql.dialect.DialectParser;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.utils.PropertyProvider;

@Component
public class ExternalDataSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(ExternalDataSourceProvider.class);
    public static final String HIGSON_RUNTIME_EXTERNAL_DATASOURCE_SQL_NAMES = "higson.runtime.external-datasource.sql.names";
    private final Map<String, DataSource> dataSources = new LinkedHashMap<String, DataSource>();
    private final String externalDataSourceNames;
    private final PropertyProvider propertyProvider;
    private DataSource standardDataSource;

    public ExternalDataSourceProvider(@Value(value="${higson.runtime.external-datasource.sql.names:}") String externalDataSourceNames, PropertyProvider propertyProvider) {
        this.externalDataSourceNames = externalDataSourceNames;
        this.propertyProvider = propertyProvider;
    }

    private static Integer toInteger(String value) {
        return value != null ? Integer.valueOf(value) : null;
    }

    public void configure(DataSource dataSource) {
        this.standardDataSource = dataSource;
        if (StringUtils.isNotBlank((CharSequence)this.externalDataSourceNames)) {
            Object[] codes = this.getDataSourceNames(this.externalDataSourceNames);
            log.info("creating external datasources: {}", (Object)Arrays.toString(codes));
            for (Object token : codes) {
                this.createDataSource((String)token);
            }
        }
    }

    public DataSource getDataSource(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return this.standardDataSource;
        }
        return this.dataSources.get(code);
    }

    public void close() {
        for (Map.Entry<String, DataSource> e : this.dataSources.entrySet()) {
            String code = e.getKey();
            DataSource dataSource = e.getValue();
            log.info("closing external datasource: {}", (Object)code);
            this.close(dataSource);
        }
    }

    public Collection<String> getDataSourceNames() {
        return new ArrayList<String>(this.dataSources.keySet());
    }

    public boolean hasExternalDataSourceWith(String externalSourceCode) {
        return this.dataSources.containsKey(externalSourceCode);
    }

    private String[] getDataSourceNames(String text) {
        String[] tokens = EngineUtil.split((String)text, (char)',');
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    private void createDataSource(String dataSourceCode) {
        log.info("creating datasource: {}", (Object)dataSourceCode);
        String url = this.getProp("higson.runtime.external-datasource.sql.%s.url", dataSourceCode);
        String user = this.getProp("higson.runtime.external-datasource.sql.%s.username", dataSourceCode);
        String pass = this.getProp("higson.runtime.external-datasource.sql.%s.password", dataSourceCode);
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)user)) {
            log.warn("datasource {} - incomplete configuration, skipping...", (Object)dataSourceCode);
            return;
        }
        this.createDataSource(dataSourceCode, url, user, pass);
    }

    private void createDataSource(String dataSourceCode, String url, String user, String pass) {
        try {
            log.info("creating datasource with url: {}, user: {}", (Object)url, (Object)user);
            DataSource dataSource = this.create(dataSourceCode, url, user, pass);
            this.register(dataSourceCode, dataSource);
        }
        catch (PropertyVetoException | RuntimeException e) {
            log.error("failed to create datasource: {}", (Object)dataSourceCode, (Object)e);
        }
    }

    private DataSource create(String dataSourceCode, String url, String user, String pass) throws PropertyVetoException {
        ComboPooledDataSource ds = new ComboPooledDataSource();
        RuntimeDialect runtimeDialect = this.getExternalSourceDialect(url);
        Integer minPoolSize = ExternalDataSourceProvider.toInteger(this.getProp("higson.runtime.external-datasource.sql.%s.min-pool-size", dataSourceCode));
        Integer maxPoolSize = ExternalDataSourceProvider.toInteger(this.getProp("higson.runtime.external-datasource.sql.%s.max-pool-size", dataSourceCode));
        ds.setDriverClass(runtimeDialect.jdbcDriverClassName());
        ds.setJdbcUrl(url);
        ds.setUser(user);
        ds.setPassword(pass);
        ds.setInitialPoolSize(1);
        ds.setMinPoolSize(minPoolSize != null ? minPoolSize : 1);
        ds.setMaxPoolSize(maxPoolSize != null ? maxPoolSize : 8);
        ds.setPreferredTestQuery(runtimeDialect.validationQuery());
        ds.setIdleConnectionTestPeriod(20);
        ds.setMaxConnectionAge(600);
        ds.setCheckoutTimeout(120000);
        ds.setUnreturnedConnectionTimeout(7200);
        return new DataSourceProxy((DataSource)ds);
    }

    private RuntimeDialect getExternalSourceDialect(String url) {
        String databaseDialect = DialectParser.getDatabaseDialect((String)url);
        log.debug("resolved dialect:{} from url:{}", (Object)databaseDialect, (Object)url);
        return DialectRegistry.getDialectFor((String)databaseDialect);
    }

    private void register(String code, DataSource dataSource) {
        log.info("registering datasource: {} -> {}", (Object)code, (Object)dataSource);
        this.dataSources.put(code, dataSource);
    }

    private void close(DataSource dataSource) {
        if (dataSource instanceof ComboPooledDataSource) {
            try {
                ((ComboPooledDataSource)dataSource).close();
            }
            catch (RuntimeException e) {
                log.error("failed to close external datasource", (Throwable)e);
            }
        }
    }

    private String getProp(String pattern, String dataSourceCode) {
        String propName = String.format(pattern, dataSourceCode);
        return this.propertyProvider.getProperty(propName);
    }

    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }
}

