/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.logger;

import io.higson.runtime.sql.DialectTemplate;
import io.higson.runtime.sql.RuntimeDialect;
import io.higson.runtime.sql.dialect.DefaultDialect;
import java.util.LinkedHashMap;
import java.util.Map;
import pl.decerto.hyperon.common.logger.ConfigurationLoggerSection;

class DatabaseDialectConfigurationLoggerSection
implements ConfigurationLoggerSection {
    private final DialectTemplate dialectTemplate;

    @Override
    public String getName() {
        return "Database dialect";
    }

    @Override
    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        RuntimeDialect dialect = this.dialectTemplate.getDialect();
        properties.put("Dialect class name", dialect.getClass().getName());
        properties.put("JDBC driver class", dialect.jdbcDriverClassName());
        properties.put("Hibernate dialect", dialect.hibernateDialect());
        properties.put("Select from sequence query", dialect.selectFromSequence("[seq]"));
        properties.put("Validation query", dialect.validationQuery());
        if (dialect instanceof DefaultDialect) {
            DefaultDialect defaultDialect = (DefaultDialect)dialect;
            properties.put("Column name replacements", defaultDialect.getColumnAliases());
            properties.put("Table  name replacements", defaultDialect.getTableAliases());
        }
        return properties;
    }

    public DatabaseDialectConfigurationLoggerSection(DialectTemplate dialectTemplate) {
        this.dialectTemplate = dialectTemplate;
    }
}

