/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.logger;

import io.higson.runtime.sql.DialectTemplate;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import pl.decerto.hyperon.common.logger.ApplicationConfigurationLoggerSection;
import pl.decerto.hyperon.common.logger.ApplicationInfoProperties;
import pl.decerto.hyperon.common.logger.ConfigurationLoggerCondition;
import pl.decerto.hyperon.common.logger.ConfigurationLoggerSection;
import pl.decerto.hyperon.common.logger.ConfigurationPrinter;
import pl.decerto.hyperon.common.logger.DatabaseDialectConfigurationLoggerSection;
import pl.decerto.hyperon.common.logger.ExternalDatasourceConfigurationLoggerSection;
import pl.decerto.hyperon.common.logger.LogoProvider;
import pl.decerto.hyperon.common.logger.PasswordEncoderConfigurationLoggerSection;
import pl.decerto.hyperon.common.logger.RuntimeRestSecurityLoggerSection;
import pl.decerto.hyperon.common.logger.StartupConfigurationLogger;
import pl.decerto.hyperon.common.security.configuration.RuntimeRestSecurityCondition;
import pl.decerto.hyperon.common.security.configuration.SecurityProperties;
import pl.decerto.hyperon.common.utils.PropertyProvider;

@EnableConfigurationProperties(value={ApplicationInfoProperties.class})
@ConfigurationLoggerCondition
@Configuration
class LoggerConfiguration {
    LoggerConfiguration() {
    }

    @Bean
    LogoProvider logoProvider(ResourceLoader resourceLoader, ApplicationInfoProperties applicationInfoProperties) {
        return new LogoProvider(resourceLoader, applicationInfoProperties);
    }

    @Bean
    ConfigurationPrinter configurationPrinter(LogoProvider logoProvider) {
        return new ConfigurationPrinter(logoProvider);
    }

    @Bean
    StartupConfigurationLogger startupConfigurationLogger(ConfigurationPrinter configurationPrinter, List<ConfigurationLoggerSection> configurationLoggerSections) {
        return new StartupConfigurationLogger(configurationPrinter, configurationLoggerSections);
    }

    @Bean
    ApplicationConfigurationLoggerSection applicationConfigurationLogger(ApplicationInfoProperties applicationInfoProperties) {
        return new ApplicationConfigurationLoggerSection(applicationInfoProperties);
    }

    @Bean
    PasswordEncoderConfigurationLoggerSection passwordEncoderConfigurationLogger(SecurityProperties securityProperties) {
        return new PasswordEncoderConfigurationLoggerSection(securityProperties);
    }

    @Bean
    ExternalDatasourceConfigurationLoggerSection coreExternalDatasourceConfigurationLogger(PropertyProvider propertyProvider) {
        return new ExternalDatasourceConfigurationLoggerSection(propertyProvider);
    }

    @Bean
    DatabaseDialectConfigurationLoggerSection databaseDialectConfigurationLogger(DialectTemplate dialectTemplate) {
        return new DatabaseDialectConfigurationLoggerSection(dialectTemplate);
    }

    @Bean
    @Conditional(value={RuntimeRestSecurityCondition.class})
    RuntimeRestSecurityLoggerSection runtimeRestSecurityLoggerSection(@Value(value="${higson.runtime-rest.security.type}") String runtimeRestSecurityType) {
        return new RuntimeRestSecurityLoggerSection(runtimeRestSecurityType);
    }
}

