/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.profiler;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Profiler {
    private final String name;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();

    public Profiler(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public Entry getEntry(String key) {
        return this.entries.get(key);
    }

    public Collection<Entry> getEntries() {
        return this.entries.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrence(String key, long time) {
        Entry entry = this.entries.get(key);
        if (entry == null) {
            Map<String, Entry> map = this.entries;
            synchronized (map) {
                entry = this.entries.get(key);
                if (entry == null) {
                    entry = new Entry(key);
                    this.entries.put(key, entry);
                }
            }
        }
        entry.addOccurrence(time);
    }

    public Monitor startProfile(String key) {
        return new Monitor(key);
    }

    public void clear() {
        this.entries.clear();
    }

    public void clear(String key) {
        this.entries.remove(key);
    }

    public String toString() {
        int keyFieldLength = 70;
        int countFieldLength = 10;
        int timeFieldLength = 15;
        StringBuilder sb = new StringBuilder();
        sb.append("Profiler{").append(this.name).append('}');
        sb.append('\n').append(Strings.padEnd((String)"key", (int)keyFieldLength, (char)' '));
        sb.append('|').append(Strings.padEnd((String)"count", (int)countFieldLength, (char)' '));
        sb.append('|').append(Strings.padEnd((String)"total[ms]", (int)timeFieldLength, (char)' '));
        sb.append('|').append(Strings.padEnd((String)"min[us]", (int)timeFieldLength, (char)' '));
        sb.append('|').append(Strings.padEnd((String)"max[us]", (int)timeFieldLength, (char)' '));
        sb.append("|avg[us]");
        for (Map.Entry<String, Entry> element : this.entries.entrySet()) {
            Entry entry = element.getValue();
            sb.append('\n').append(Strings.padEnd((String)entry.getKey(), (int)keyFieldLength, (char)' '));
            sb.append('|').append(Strings.padEnd((String)Integer.toString(entry.getCount()), (int)countFieldLength, (char)' '));
            sb.append('|').append(Strings.padEnd((String)Long.toString(TimeUnit.MICROSECONDS.toMillis(entry.getTotalTime())), (int)timeFieldLength, (char)' '));
            sb.append('|').append(Strings.padEnd((String)Long.toString(entry.getMinTime()), (int)timeFieldLength, (char)' '));
            sb.append('|').append(Strings.padEnd((String)Long.toString(entry.getMaxTime()), (int)timeFieldLength, (char)' '));
            sb.append('|').append(entry.getAvgTime());
        }
        return sb.toString();
    }

    public final class Entry {
        private final String key;
        private int count = 0;
        private long totalTime = 0L;
        private long minTime = Long.MAX_VALUE;
        private long maxTime = 0L;
        private double avgTime = 0.0;

        private Entry(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key);
        }

        public synchronized void addOccurrence(long time) {
            ++this.count;
            this.totalTime += time;
            if (this.minTime > time) {
                this.minTime = time;
            }
            if (this.maxTime < time) {
                this.maxTime = time;
            }
            this.avgTime = (double)this.totalTime / (double)this.count;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("count", this.count).add("totalTime", this.totalTime).add("minTime", this.minTime).add("maxTime", this.maxTime).add("avgTime", this.avgTime).toString();
        }

        public String getKey() {
            return this.key;
        }

        public int getCount() {
            return this.count;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public long getMinTime() {
            return this.minTime;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public double getAvgTime() {
            return this.avgTime;
        }
    }

    public final class Monitor
    implements AutoCloseable {
        private final String key;
        private final long startTime;
        private Long endTime;

        private Monitor(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key);
            this.startTime = System.nanoTime();
        }

        public String getKey() {
            return this.key;
        }

        public long getActTime() {
            return TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - this.startTime);
        }

        public long getTotalTime() {
            if (this.endTime == null) {
                throw new IllegalStateException(String.format("profiler monitor for key {%S} is now running", this.key));
            }
            return TimeUnit.NANOSECONDS.toMicros(this.endTime - this.startTime);
        }

        public void stopProfile() {
            if (this.endTime != null) {
                throw new IllegalStateException(String.format("profiler monitor for key {%s} was already stopped", this.key));
            }
            this.endTime = System.nanoTime();
            Profiler.this.addOccurrence(this.key, this.getTotalTime());
        }

        @Override
        public void close() {
            this.stopProfile();
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
            helper.add("key", (Object)this.key);
            if (this.endTime != null) {
                helper.add("totalTime", this.getTotalTime());
            } else {
                helper.add("actTime", this.getActTime());
            }
            return helper.toString();
        }
    }
}

