/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.dao;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import pl.decerto.hyperon.common.security.domain.JwtToken;
import pl.decerto.hyperon.common.security.domain.TokenType;

public interface JwtTokenDao
extends JpaRepository<JwtToken, Integer> {
    @Query(value="select jt from JwtToken jt where jt.user.id = :id and jt.tokenType = :type")
    public List<JwtToken> findTokens(@Param(value="id") int var1, @Param(value="type") TokenType var2);

    public List<JwtToken> findByTokenTypeIn(Set<TokenType> var1);

    public Optional<JwtToken> findByTokenAndTokenType(String var1, TokenType var2);

    public void deleteJwtTokensByTokenInAndTokenTypeIn(List<String> var1, Set<TokenType> var2);

    @Modifying
    @Query(value="delete from JwtToken jt where jt.expirationDate < current_timestamp and jt.tokenType = :type")
    public int deleteExpiredTokens(@Param(value="type") TokenType var1);

    @Modifying
    public void deleteAllByUserIdAndTokenType(int var1, TokenType var2);
}

