/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.time.LocalDateTime;
import pl.decerto.hyperon.common.persistence.jpa.BaseEntity;

@Entity(name="PasswordHistory")
public class PasswordHistory
extends BaseEntity {
    @Id
    @SequenceGenerator(name="passwordhistory_id_generator", sequenceName="SEQ_PASSWORD_HISTORY")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="passwordhistory_id_generator")
    private int id;
    @Column(name="userid")
    private int userId;
    private String password;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="createdate")
    private LocalDateTime createDate = LocalDateTime.now();

    public String toString() {
        return "PasswordHistory{id=" + this.id + ", userId=" + this.userId + ", createDate='" + this.createDate + "'}";
    }

    @Override
    public int getId() {
        return this.id;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public LocalDateTime getCreateDate() {
        return this.createDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PasswordHistory)) {
            return false;
        }
        PasswordHistory other = (PasswordHistory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getUserId() != other.getUserId()) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        LocalDateTime this$createDate = this.getCreateDate();
        LocalDateTime other$createDate = other.getCreateDate();
        return !(this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PasswordHistory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getUserId();
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        LocalDateTime $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        return result;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

