/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.jwt;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.stream.Collectors;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.domain.JwtToken;
import pl.decerto.hyperon.common.security.domain.SystemRightJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.domain.TokenType;
import pl.decerto.hyperon.common.security.jwt.JwtSecretKeyNotSpecifiedException;
import pl.decerto.hyperon.common.utils.Messages;

@Component
public class JwtTokenGenerator {
    private static final String USER_LOGIN_CLAIM = "userLogin";
    private static final String FIRST_NAME_CLAIM = "firstName";
    private static final String LAST_NAME_CLAIM = "lastName";
    private static final String EMAIL_CLAIM = "email";
    private static final String TYPE_CLAIM = "type";
    private static final String STATUS_CLAIM = "status";
    private static final String AUTHORITIES_CLAIM = "authorities";
    private static final String AUTHORITIES_SEPARATOR = ",";
    private final String runtimeSecretKey;
    private final String studioSecretKey;

    public JwtTokenGenerator(@Value(value="${higson.security.jwt.secret-key:#{null}}") String runtimeSecretKey, @Value(value="${higson.studio.security.token.generation.secret-key:#{null}}") String studioSecretKey) {
        this.runtimeSecretKey = runtimeSecretKey;
        this.studioSecretKey = studioSecretKey;
    }

    public JwtToken generateJwtToken(TokenType type, SystemUserJPA currentUser, LocalDateTime expirationDate) {
        return switch (type) {
            case TokenType.RUNTIME_REST_TOKEN -> this.generateRuntimeJwtToken(currentUser, expirationDate);
            case TokenType.STUDIO_INTEGRATION_TOKEN -> this.generateStudioIntegrationJwtToken(currentUser, expirationDate);
            default -> throw new IllegalArgumentException("Unsupported token type " + type);
        };
    }

    private JwtToken generateRuntimeJwtToken(SystemUserJPA user, LocalDateTime expirationDate) {
        if (StringUtils.isBlank((CharSequence)this.runtimeSecretKey)) {
            throw new JwtSecretKeyNotSpecifiedException(Messages.message("runtime.jwt.secret.notSpecified"));
        }
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        byte[] apiKeySecretBytes = this.runtimeSecretKey.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setIssuedAt((Date)Timestamp.valueOf(LocalDateTime.now())).setExpiration((Date)Timestamp.valueOf(expirationDate)).claim(USER_LOGIN_CLAIM, (Object)user.getLogin()).claim(FIRST_NAME_CLAIM, (Object)user.getFirstName()).claim(LAST_NAME_CLAIM, (Object)user.getLastName()).claim(EMAIL_CLAIM, (Object)user.getEmail()).claim(TYPE_CLAIM, (Object)TokenType.RUNTIME_REST_TOKEN).signWith((Key)signingKey, signatureAlgorithm);
        String jwtToken = builder.compact();
        return this.getJwtTokenEntity(jwtToken, TokenType.RUNTIME_REST_TOKEN, user, expirationDate);
    }

    private JwtToken generateStudioIntegrationJwtToken(SystemUserJPA user, LocalDateTime expirationDate) {
        if (StringUtils.isBlank((CharSequence)this.studioSecretKey)) {
            throw new JwtSecretKeyNotSpecifiedException(Messages.message("studio.integration.jwt.secret.notSpecified"));
        }
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        byte[] apiKeySecretBytes = this.studioSecretKey.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setIssuedAt((Date)Timestamp.valueOf(LocalDateTime.now())).setExpiration((Date)Timestamp.valueOf(expirationDate)).claim(USER_LOGIN_CLAIM, (Object)user.getLogin()).claim(FIRST_NAME_CLAIM, (Object)user.getFirstName()).claim(LAST_NAME_CLAIM, (Object)user.getLastName()).claim(EMAIL_CLAIM, (Object)user.getEmail()).claim(STATUS_CLAIM, (Object)user.getStatus()).claim(AUTHORITIES_CLAIM, (Object)this.mapAuthorities(user)).claim(TYPE_CLAIM, (Object)TokenType.STUDIO_INTEGRATION_TOKEN).signWith((Key)signingKey, signatureAlgorithm);
        String jwtToken = builder.compact();
        return this.getJwtTokenEntity(jwtToken, TokenType.STUDIO_INTEGRATION_TOKEN, user, expirationDate);
    }

    private String mapAuthorities(SystemUserJPA user) {
        return user.getRoles().stream().flatMap(role -> role.getRights().stream()).map(SystemRightJPA::getCode).collect(Collectors.joining(AUTHORITIES_SEPARATOR));
    }

    private JwtToken getJwtTokenEntity(String jwtToken, TokenType tokenType, SystemUserJPA user, LocalDateTime expirationDate) {
        JwtToken jwtTokenEntity = new JwtToken();
        jwtTokenEntity.setCreateDate(LocalDateTime.now());
        jwtTokenEntity.setExpirationDate(expirationDate);
        jwtTokenEntity.setToken(jwtToken);
        jwtTokenEntity.setUser(user);
        jwtTokenEntity.setTokenType(tokenType);
        return jwtTokenEntity;
    }
}

