/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.oauth2;

import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.AbstractExternalSystemUserCreator;
import pl.decerto.hyperon.common.security.SystemRoleManagementService;
import pl.decerto.hyperon.common.security.SystemUserValidator;
import pl.decerto.hyperon.common.security.UserManagementService;
import pl.decerto.hyperon.common.security.oauth2.HyperonOidcUserDetails;
import pl.decerto.hyperon.common.security.oauth2.OAuth2PropertyCondition;

@Component
@OAuth2PropertyCondition
public class OAuth2SystemUserCreator
extends AbstractExternalSystemUserCreator<HyperonOidcUserDetails> {
    private static final Logger log = LoggerFactory.getLogger(OAuth2SystemUserCreator.class);
    private static final String FIRST_NAME_AND_SURNAME_ATTRIBUTE_NAME = "name";
    private static final String EMAIL_ATTRIBUTE_NAME = "email";

    public OAuth2SystemUserCreator(SystemUserValidator systemUserValidator, UserManagementService userManagementService, SystemRoleManagementService systemRoleManagementService) {
        super(systemUserValidator, userManagementService, systemRoleManagementService);
    }

    @Override
    protected String[] getRoles(HyperonOidcUserDetails userInfo) {
        return (String[])userInfo.getAuthorities().stream().map(GrantedAuthority::getAuthority).map(AuthorityMapper::map).distinct().toArray(String[]::new);
    }

    @Override
    protected String getFirstName(HyperonOidcUserDetails userInfo) {
        String firstAndLastName = this.getFirstAndLastName(userInfo);
        return StringUtils.isNotBlank((CharSequence)firstAndLastName) ? firstAndLastName.substring(0, firstAndLastName.indexOf(" ")) : null;
    }

    @Override
    protected String getLastName(HyperonOidcUserDetails userInfo) {
        String firstAndLastName = this.getFirstAndLastName(userInfo);
        return StringUtils.isNotBlank((CharSequence)firstAndLastName) ? firstAndLastName.substring(firstAndLastName.indexOf(" ") + 1) : null;
    }

    @Override
    protected String getEmail(HyperonOidcUserDetails userInfo) {
        return (String)userInfo.getAttribute(EMAIL_ATTRIBUTE_NAME);
    }

    @Override
    protected boolean isExternalRolesOrigin() {
        return true;
    }

    private String getFirstAndLastName(HyperonOidcUserDetails userInfo) {
        return (String)userInfo.getAttribute(FIRST_NAME_AND_SURNAME_ATTRIBUTE_NAME);
    }

    private static class AuthorityMapper {
        private static final Map<String, String> MPP_ROLES = Map.of("ADMIN", "MPP_ADMIN", "USER", "MPP_USER", "INTEGRATION", "MPP_INTEGRATION", "USER_READONLY", "MPP_USER_READONLY", "SYSTEM_SCHEDULER", "MPP_SYSTEM_SCHEDULER");

        static String map(String authority) {
            return Optional.ofNullable(authority).map(String::toUpperCase).map(MPP_ROLES::get).orElseGet(() -> {
                log.warn("Authority {} is not suitable role for MPP user", (Object)authority);
                return "MPP_USER";
            });
        }

        private AuthorityMapper() {
        }
    }
}

