/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.concurrent;

import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadLockerOnEquals {
    private final Map<Object, Unlocker> unlockers = new HashMap<Object, Unlocker>();

    public Unlocker lockOn(@NotNull Object object) {
        Unlocker unlocker = this.getUnlocker(object);
        unlocker.internalLock.lock();
        return unlocker;
    }

    public Optional<Unlocker> tryLockOn(@NotNull Object object) {
        Unlocker unlocker = this.getUnlocker(object);
        if (unlocker.internalLock.tryLock()) {
            return Optional.of(unlocker);
        }
        this.returnAfterUse(unlocker);
        return Optional.empty();
    }

    public Optional<Unlocker> tryLockOn(@NotNull Object object, long time, TimeUnit unit) throws InterruptedException {
        Unlocker unlocker = this.getUnlocker(object);
        if (unlocker.internalLock.tryLock(time, unit)) {
            return Optional.of(unlocker);
        }
        this.returnAfterUse(unlocker);
        return Optional.empty();
    }

    private synchronized Unlocker getUnlocker(@NotNull Object object) {
        Objects.requireNonNull(object, "Attempt to acquire Unlocker for null object");
        Unlocker unlocker = this.unlockers.computeIfAbsent(object, x$0 -> new Unlocker(x$0));
        ++unlocker.userCount;
        return unlocker;
    }

    private synchronized void returnAfterUse(@NotNull Unlocker unlocker) {
        if (--unlocker.userCount <= 0) {
            this.unlockers.remove(unlocker.objectLockedOn);
        }
    }

    public class Unlocker {
        private final Object objectLockedOn;
        private final Lock internalLock = new ReentrantLock();
        private int userCount;

        private Unlocker(Object objectLockedOn) {
            this.objectLockedOn = objectLockedOn;
        }

        public void unlock() {
            this.internalLock.unlock();
            ThreadLockerOnEquals.this.returnAfterUse(this);
        }
    }
}

