/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class AbstractTypedResourceBundle<T>
extends ResourceBundle {
    protected abstract T handleGetObject(String var1);

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    protected abstract Set<String> handleKeySet();

    public T getValue(String key) {
        Object value = this.getObject(key);
        return (T)value;
    }

    public static <U, V extends AbstractTypedResourceBundle<U>> V getTypedBundle(String baseName, AbstractTypedControl<U, V> control) {
        AbstractTypedResourceBundle result = (AbstractTypedResourceBundle)ResourceBundle.getBundle(baseName, control);
        return (V)result;
    }

    public static abstract class AbstractTypedControl<T, R extends AbstractTypedResourceBundle<T>>
    extends ResourceBundle.Control {
        private final List<String> supportedFormats;

        protected AbstractTypedControl(List<String> formats) {
            this.supportedFormats = formats;
        }

        @Override
        public List<String> getFormats(String baseName) {
            Objects.requireNonNull(baseName);
            return this.supportedFormats;
        }

        public R newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException, InstantiationException, IllegalAccessException {
            if (baseName == null || locale == null || format == null || loader == null) {
                throw new NullPointerException();
            }
            if (this.supportedFormats.contains(format)) {
                return this.getTypedBundle(baseName, locale, format, loader, reload);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private R getTypedBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException, IllegalAccessException, InstantiationException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, format);
            URL url = loader.getResource(resourceName);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            if (connection == null) {
                return null;
            }
            if (reload) {
                connection.setUseCaches(false);
            }
            try (InputStream stream = connection.getInputStream();){
                if (stream == null) {
                    R r = null;
                    return r;
                }
                BufferedInputStream bis = new BufferedInputStream(stream);
                R r = this.readBundle(bis, format);
                return r;
            }
            catch (IOException | IllegalAccessException | InstantiationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        protected abstract R readBundle(BufferedInputStream var1, String var2) throws IOException, IllegalAccessException, InstantiationException;
    }
}

