/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.TextNormalizationOptions;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.builtin.utils.IdentifyValueUtil;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.type.AbstractValueHolder;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.bool.BooleanHolder;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.string.StringHolder;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class EqualsUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    public static final String CODE = "equals";
    public static final UtilFunction INSTANCE = new EqualsUtilFunction();

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        Object targetObject = ctx.get(path);
        if (args.length < 2) {
            throw this.createHigsonRuntimeException(CODE, "requires at least two arguments.");
        }
        return this.isEqual(ctx, targetObject, args);
    }

    private Boolean isEqual(HigsonContext ctx, Object targetObject, Object[] args) {
        Object otherObject = args[1];
        if (ctx.has(converter.getString(args[1]))) {
            otherObject = ctx.get(converter.getString(args[1]));
        }
        if (targetObject == null && otherObject == null) {
            return true;
        }
        Optional<ValueHolder> targetObjOptional = IdentifyValueUtil.identify(targetObject);
        Optional<ValueHolder> otherObjOptional = IdentifyValueUtil.identify(otherObject);
        if (targetObjOptional.isEmpty() || otherObjOptional.isEmpty()) {
            throw this.createHigsonRuntimeException(CODE, "Cannot compare at least one of the types is not supported");
        }
        return targetObjOptional.flatMap(targetObjectHolder -> otherObjOptional.map(otherValueHolder -> this.compare((ValueHolder)targetObjectHolder, (ValueHolder)otherValueHolder, args))).orElse(null);
    }

    private Boolean compare(ValueHolder targetObjectHolder, ValueHolder otherValueHolder, Object[] args) {
        AbstractValueHolder target;
        if (targetObjectHolder instanceof NumberHolder) {
            target = (NumberHolder)targetObjectHolder;
            if (otherValueHolder instanceof NumberHolder) {
                NumberHolder other = (NumberHolder)otherValueHolder;
                return ((NumberHolder)target).getValue().equals(other.getValue());
            }
        }
        if (targetObjectHolder instanceof IntegerHolder) {
            target = (IntegerHolder)targetObjectHolder;
            if (otherValueHolder instanceof IntegerHolder) {
                IntegerHolder other = (IntegerHolder)otherValueHolder;
                return ((IntegerHolder)target).getValue().equals(other.getValue());
            }
        }
        if (targetObjectHolder instanceof BooleanHolder) {
            target = (BooleanHolder)targetObjectHolder;
            if (otherValueHolder instanceof BooleanHolder) {
                BooleanHolder other = (BooleanHolder)otherValueHolder;
                return ((BooleanHolder)target).getValue().equals(other.getValue());
            }
        }
        if (targetObjectHolder instanceof LocalDateHolder) {
            target = (LocalDateHolder)targetObjectHolder;
            if (otherValueHolder instanceof LocalDateHolder) {
                LocalDateHolder other = (LocalDateHolder)otherValueHolder;
                return ((LocalDateHolder)target).getValue().equals(other.getValue());
            }
        }
        if (targetObjectHolder instanceof LocalDateTimeHolder) {
            target = (LocalDateTimeHolder)targetObjectHolder;
            if (otherValueHolder instanceof LocalDateTimeHolder) {
                LocalDateTimeHolder other = (LocalDateTimeHolder)otherValueHolder;
                return ((LocalDateTimeHolder)target).getValue().equals(other.getValue());
            }
        }
        if (targetObjectHolder instanceof StringHolder) {
            StringHolder targetHolder = (StringHolder)targetObjectHolder;
            if (otherValueHolder instanceof StringHolder) {
                StringHolder otherHolder = (StringHolder)otherValueHolder;
                return this.stringsEqualsConsideringNormalizationOptions(args, targetHolder, otherHolder);
            }
        }
        throw this.createCannotCompareHigsonException(targetObjectHolder, otherValueHolder);
    }

    private HigsonRuntimeException createCannotCompareHigsonException(ValueHolder targetObjectHolder, ValueHolder otherValueHolder) {
        return this.createHigsonRuntimeException(CODE, "Cannot compare '" + targetObjectHolder.getValue() + "' to '" + otherValueHolder.getValue() + "' types do not match");
    }

    private boolean stringsEqualsConsideringNormalizationOptions(Object[] args, StringHolder targetHolder, StringHolder otherHolder) {
        String target = targetHolder.getValue();
        String other = otherHolder.getValue();
        if (this.isIgnoreCase(args)) {
            target = target.toLowerCase();
            other = other.toLowerCase();
        }
        if (this.isTrim(args)) {
            target = target.trim();
            other = other.trim();
        }
        return target.equals(other);
    }

    private boolean isIgnoreCase(Object[] args) {
        return Arrays.stream(args).filter(Objects::nonNull).map(converter::getString).anyMatch(TextNormalizationOptions::isIgnoreCase);
    }

    private boolean isTrim(Object[] args) {
        return Arrays.stream(args).filter(Objects::nonNull).map(converter::getString).anyMatch(TextNormalizationOptions::isTrim);
    }

    private EqualsUtilFunction() {
    }
}

