/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.implementation;

import io.higson.runtime.builtin.implementation.ContextualUtilFunction;
import io.higson.runtime.builtin.implementation.TextFormat;
import io.higson.runtime.builtin.implementation.UtilFunction;
import io.higson.runtime.builtin.utils.IdentifyValueUtil;
import io.higson.runtime.core.HigsonContext;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.integer.IntegerHolder;
import io.higson.runtime.engine.types.number.NumberHolder;
import io.higson.runtime.engine.types.string.StringHolder;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatUtilFunction
extends UtilFunction
implements ContextualUtilFunction {
    private static final Logger log = LoggerFactory.getLogger(FormatUtilFunction.class);
    public static final String CODE = "format";
    public static final UtilFunction INSTANCE = new FormatUtilFunction();

    @Override
    public Object call(HigsonContext ctx, Object[] args) {
        String path = this.getContextPath(converter, args);
        Object object = ctx.get(path);
        if (args.length > 2) {
            throw new HigsonRuntimeException("Util functionformat: missing format argument");
        }
        return this.format(args, object);
    }

    private Object format(Object[] args, Object targetObject) {
        if (targetObject instanceof Collection) {
            Collection list = (Collection)targetObject;
            return this.formatList(args, list);
        }
        return IdentifyValueUtil.identify(targetObject).map(targetObjectHolder -> this.format(args, targetObject, (ValueHolder)targetObjectHolder)).orElse(null);
    }

    private Object format(Object[] args, Object targetObject, ValueHolder targetObjectHolder) {
        if (targetObjectHolder instanceof NumberHolder) {
            NumberHolder holder = (NumberHolder)targetObjectHolder;
            return this.formatNumber(args, holder.getValue());
        }
        if (targetObjectHolder instanceof IntegerHolder) {
            IntegerHolder holder = (IntegerHolder)targetObjectHolder;
            return this.formatNumber(args, holder.getValue());
        }
        if (targetObjectHolder instanceof StringHolder) {
            StringHolder holder = (StringHolder)targetObjectHolder;
            return this.formatText(args, holder.getValue());
        }
        if (targetObjectHolder instanceof LocalDateHolder) {
            LocalDateHolder holder = (LocalDateHolder)targetObjectHolder;
            return this.formatLocalDate(args, holder.getValue());
        }
        if (targetObjectHolder instanceof LocalDateTimeHolder) {
            LocalDateTimeHolder holder = (LocalDateTimeHolder)targetObjectHolder;
            return this.formatLocalDateTime(args, holder.getValue());
        }
        throw this.createHigsonRuntimeException(CODE, "Unsupported element type for formatting: " + targetObject.getClass().getSimpleName());
    }

    private List formatList(Object[] args, Collection<Object> list) {
        return list.stream().map(IdentifyValueUtil::identify).map(optional -> optional.map(valueHolder -> this.formatElement((ValueHolder)valueHolder, args)).orElse(null)).toList();
    }

    private Object formatElement(ValueHolder element, Object[] args) {
        if (element instanceof NumberHolder) {
            NumberHolder holder = (NumberHolder)element;
            return this.formatNumber(args, holder.getValue());
        }
        if (element instanceof IntegerHolder) {
            IntegerHolder holder = (IntegerHolder)element;
            return this.formatNumber(args, holder.getValue());
        }
        if (element instanceof StringHolder) {
            StringHolder holder = (StringHolder)element;
            return this.formatText(args, holder.getValue());
        }
        if (element instanceof LocalDateHolder) {
            LocalDateHolder holder = (LocalDateHolder)element;
            return this.formatLocalDate(args, holder.getValue());
        }
        if (element instanceof LocalDateTimeHolder) {
            LocalDateTimeHolder holder = (LocalDateTimeHolder)element;
            return this.formatLocalDateTime(args, holder.getValue());
        }
        throw this.createHigsonRuntimeException(CODE, "Unsupported element type for formatting: " + element.getClass().getSimpleName());
    }

    private String formatText(Object[] args, String text) {
        String format = converter.getString(args[1]);
        TextFormat textFormat = TextFormat.fromString(format);
        return switch (textFormat) {
            default -> throw new IncompatibleClassChangeError();
            case TextFormat.LOWER -> text.toLowerCase();
            case TextFormat.UPPER -> text.toUpperCase();
            case TextFormat.CAPITALIZE -> StringUtils.capitalize((String)text);
            case TextFormat.REVERSE -> new StringBuilder(text).reverse().toString();
        };
    }

    private String formatNumber(Object[] args, Object object) {
        String format = this.handleDecimalFormat(args);
        BigDecimal decimal = converter.getDecimal(object);
        try {
            return new DecimalFormat(format).format(decimal);
        }
        catch (NumberFormatException exception) {
            throw this.createInvalidFormatException(format, exception);
        }
    }

    private String handleDecimalFormat(Object[] args) {
        Object format;
        Object formatArgument = args[1];
        try {
            BigDecimal decimalFormatArg = converter.getDecimal(formatArgument);
            if (decimalFormatArg != null) {
                int decimalPrecision = decimalFormatArg.intValue();
                format = "#." + "0".repeat(decimalPrecision);
            } else {
                format = converter.getString(formatArgument);
            }
        }
        catch (NumberFormatException exception) {
            throw this.createHigsonRuntimeException(CODE, "Invalid decimal format: " + formatArgument, exception);
        }
        return format;
    }

    private String formatLocalDate(Object[] args, Object object) {
        String format = converter.getString(args[1]);
        LocalDate localDate = converter.getLocalDate(object);
        try {
            return localDate.format(DateTimeFormatter.ofPattern(format));
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            throw this.createHigsonRuntimeException(CODE, format);
        }
    }

    private String formatLocalDateTime(Object[] args, Object object) {
        String format = converter.getString(args[1]);
        LocalDateTime localDateTime = converter.getLocalDateTime(object);
        try {
            return localDateTime.format(DateTimeFormatter.ofPattern(format));
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            throw this.createInvalidFormatException(format, e);
        }
    }

    private HigsonRuntimeException createInvalidFormatException(String format, RuntimeException exception) {
        return this.createHigsonRuntimeException(CODE, "Invalid format: " + format, exception);
    }

    private FormatUtilFunction() {
    }
}

