/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.builtin.utils;

import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.helper.TypeConverter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;
import org.joda.time.DateTime;

public final class IdentifyValueUtil {
    private static final TypeConverter converter = TypeConverter.getInstance();

    public static Optional<ValueHolder> identify(Object obj) {
        if (obj instanceof String) {
            String text = (String)obj;
            if (converter.getDatetimeType().canDecode(text.trim())) {
                return Optional.of(converter.toLocalDateTimeHolder(text));
            }
            if (converter.getDateType().canDecode(text)) {
                return Optional.of(converter.toLocalDateHolder(obj));
            }
            if (converter.getIntegerType().canDecode(text)) {
                return Optional.of(converter.toIntegerHolder(obj));
            }
            if (converter.getNumberType().canDecode(text)) {
                return Optional.of(converter.toNumberHolder(obj));
            }
            if (converter.getBooleanType().canDecode(text)) {
                return Optional.of(converter.toBooleanHolder(obj));
            }
            return Optional.of(converter.toStringHolder(obj));
        }
        if (obj instanceof Integer) {
            Integer integer = (Integer)obj;
            return Optional.of(converter.toIntegerHolder(integer));
        }
        if (obj instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)obj;
            return Optional.of(converter.toNumberHolder(decimal));
        }
        if (obj instanceof LocalDate) {
            return Optional.of(converter.toLocalDateHolder(obj));
        }
        if (obj instanceof DateTime || obj instanceof LocalDateTime || obj instanceof Date) {
            return Optional.of(converter.toLocalDateTimeHolder(obj));
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return Optional.of(converter.toBooleanHolder(bool));
        }
        return Optional.empty();
    }

    private IdentifyValueUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

